/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamExpression
implements StreamExpressionParameter {
    private String functionName;
    private List<StreamExpressionParameter> parameters;

    public StreamExpression(String functionName) {
        this.functionName = functionName;
        this.parameters = new ArrayList<StreamExpressionParameter>();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        if (null == functionName) {
            throw new IllegalArgumentException("Null functionName is not allowed.");
        }
        this.functionName = functionName;
    }

    public StreamExpression withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void addParameter(StreamExpressionParameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(String parameter) {
        this.addParameter(new StreamExpressionValue(parameter));
    }

    public StreamExpression withParameter(StreamExpressionParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public StreamExpression withParameter(String parameter) {
        return this.withParameter(new StreamExpressionValue(parameter));
    }

    public List<StreamExpressionParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<StreamExpressionParameter> parameters) {
        if (null == parameters) {
            throw new IllegalArgumentException("Null parameter list is not allowed.");
        }
        this.parameters = parameters;
    }

    public StreamExpression withParameters(List<StreamExpressionParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.functionName);
        sb.append("(");
        for (int idx = 0; idx < this.parameters.size(); ++idx) {
            if (0 != idx) {
                sb.append(",");
            }
            sb.append(this.parameters.get(idx));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StreamExpression)) {
            return false;
        }
        StreamExpression check = (StreamExpression)other;
        if (null == this.functionName && null != check.functionName) {
            return false;
        }
        if (null != this.functionName && null == check.functionName) {
            return false;
        }
        if (null != this.functionName && !this.functionName.equals(check.functionName)) {
            return false;
        }
        if (this.parameters.size() != check.parameters.size()) {
            return false;
        }
        for (int idx = 0; idx < this.parameters.size(); ++idx) {
            StreamExpressionParameter right;
            StreamExpressionParameter left = this.parameters.get(idx);
            if (left.equals(right = check.parameters.get(idx))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.functionName);
    }
}

