/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadCpuTimer {
    private static final long UNSUPPORTED = -1L;
    public static final String CPU_TIME = "cpuTime";
    public static final String LOCAL_CPU_TIME = "localCpuTime";
    public static final String ENABLE_CPU_TIME = "solr.log.cputime";
    private static ThreadMXBean THREAD_MX_BEAN;
    private static final Logger log;
    private final long startCpuTimeNanos = this.getThreadTotalCpuNs();

    public static boolean isSupported() {
        return THREAD_MX_BEAN != null;
    }

    public long getElapsedCpuNs() {
        return this.startCpuTimeNanos != -1L ? this.getThreadTotalCpuNs() - this.startCpuTimeNanos : -1L;
    }

    private long getThreadTotalCpuNs() {
        if (THREAD_MX_BEAN != null) {
            return THREAD_MX_BEAN.getCurrentThreadCpuTime();
        }
        return -1L;
    }

    public Optional<Long> getElapsedCpuMs() {
        long cpuTimeNs = this.getElapsedCpuNs();
        return cpuTimeNs != -1L ? Optional.of(TimeUnit.MILLISECONDS.convert(cpuTimeNs, TimeUnit.NANOSECONDS)) : Optional.empty();
    }

    public String toString() {
        return this.getElapsedCpuMs().map(String::valueOf).orElse("UNSUPPORTED");
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        try {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            if (!threadBean.isThreadCpuTimeEnabled()) {
                threadBean.setThreadCpuTimeEnabled(true);
            }
            THREAD_MX_BEAN = threadBean;
        }
        catch (SecurityException | UnsupportedOperationException e) {
            THREAD_MX_BEAN = null;
            log.info("Thread CPU time monitoring is not available.");
        }
    }
}

