/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.ReplicaPlacement;
import org.apache.solr.cluster.placement.impl.SimpleClusterAbstractionsImpl;
import org.apache.solr.common.cloud.ReplicaPosition;

class ReplicaPlacementImpl
implements ReplicaPlacement {
    private final SolrCollection solrCollection;
    private final String shardName;
    private final Node node;
    private final Replica.ReplicaType replicaType;

    ReplicaPlacementImpl(SolrCollection solrCollection, String shardName, Node node, Replica.ReplicaType replicaType) {
        this.solrCollection = solrCollection;
        this.shardName = shardName;
        this.node = node;
        this.replicaType = replicaType;
    }

    @Override
    public SolrCollection getCollection() {
        return this.solrCollection;
    }

    @Override
    public String getShardName() {
        return this.shardName;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public Replica.ReplicaType getReplicaType() {
        return this.replicaType;
    }

    public String toString() {
        return this.solrCollection.getName() + "/" + this.shardName + "/" + this.replicaType + "->" + this.node.getName();
    }

    static List<ReplicaPosition> toReplicaPositions(String collection, Set<ReplicaPlacement> replicaPlacementSet) {
        ArrayList<ReplicaPosition> replicaPositions = new ArrayList<ReplicaPosition>(replicaPlacementSet.size());
        int index = 0;
        for (ReplicaPlacement placement : replicaPlacementSet) {
            replicaPositions.add(new ReplicaPosition(collection, placement.getShardName(), index++, SimpleClusterAbstractionsImpl.ReplicaImpl.toCloudReplicaType(placement.getReplicaType()), placement.getNode().getName()));
        }
        return replicaPositions;
    }
}

