/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class ComparisonFunction {
    public static BooleanValueStream createComparisonFunction(String name, CompResultFunction comp, AnalyticsValueStream ... params) {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream paramA = params[0];
        AnalyticsValueStream paramB = params[1];
        if (paramA instanceof DoubleValueStream && paramB instanceof DoubleValueStream) {
            if (paramA instanceof DoubleValue) {
                if (paramB instanceof DoubleValue) {
                    return new CompareDoubleValueFunction(name, (DoubleValue)paramA, (DoubleValue)paramB, comp);
                }
                return new CompareDoubleStreamFunction(name, (DoubleValue)paramA, (DoubleValueStream)paramB, comp);
            }
            if (paramB instanceof DoubleValue) {
                return new CompareDoubleStreamFunction(name, (DoubleValue)paramB, (DoubleValueStream)paramA, ComparisonFunction.reverse(comp));
            }
        } else if (paramA instanceof DateValueStream && paramB instanceof DateValueStream) {
            if (paramA instanceof DateValue) {
                if (paramB instanceof DateValue) {
                    return new CompareDateValueFunction(name, (DateValue)paramA, (DateValue)paramB, comp);
                }
                return new CompareDateStreamFunction(name, (DateValue)paramA, (DateValueStream)paramB, comp);
            }
            if (paramB instanceof DateValue) {
                return new CompareDateStreamFunction(name, (DateValue)paramB, (DateValueStream)paramA, ComparisonFunction.reverse(comp));
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires comparable (numeric or date) parameters.");
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires that at least 1 parameter be single-valued.");
    }

    private static CompResultFunction reverse(CompResultFunction original) {
        return val -> original.apply(val * -1);
    }

    static class CompareDateStreamFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final DateValue baseExpr;
        private final DateValueStream compExpr;
        private final CompResultFunction comp;
        private final String name;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public CompareDateStreamFunction(String name, DateValue baseExpr, DateValueStream compExpr, CompResultFunction comp) throws SolrException {
            this.name = name;
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.comp = comp;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            long baseValue = this.baseExpr.getLong();
            if (this.baseExpr.exists()) {
                this.compExpr.streamLongs(compValue -> cons.accept(this.comp.apply(Long.compare(baseValue, compValue))));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class CompareDateValueFunction
    extends BooleanValue.AbstractBooleanValue {
        private final DateValue exprA;
        private final DateValue exprB;
        private final CompResultFunction comp;
        private final String name;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public CompareDateValueFunction(String name, DateValue exprA, DateValue exprB, CompResultFunction comp) {
            this.name = name;
            this.exprA = exprA;
            this.exprB = exprB;
            this.comp = comp;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
        }

        @Override
        public boolean getBoolean() {
            long valueA = this.exprA.getLong();
            long valueB = this.exprB.getLong();
            this.exists = this.exprA.exists() && this.exprB.exists();
            return this.exists ? this.comp.apply(Long.compare(valueA, valueB)) : false;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class CompareDoubleStreamFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final DoubleValue baseExpr;
        private final DoubleValueStream compExpr;
        private final CompResultFunction comp;
        private final String name;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public CompareDoubleStreamFunction(String name, DoubleValue baseExpr, DoubleValueStream compExpr, CompResultFunction comp) throws SolrException {
            this.name = name;
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.comp = comp;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            double baseValue = this.baseExpr.getDouble();
            if (this.baseExpr.exists()) {
                this.compExpr.streamDoubles(compValue -> cons.accept(this.comp.apply(Double.compare(baseValue, compValue))));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class CompareDoubleValueFunction
    extends BooleanValue.AbstractBooleanValue {
        private final DoubleValue exprA;
        private final DoubleValue exprB;
        private final CompResultFunction comp;
        private final String name;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public CompareDoubleValueFunction(String name, DoubleValue exprA, DoubleValue exprB, CompResultFunction comp) {
            this.name = name;
            this.exprA = exprA;
            this.exprB = exprB;
            this.comp = comp;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
        }

        @Override
        public boolean getBoolean() {
            double valueA = this.exprA.getDouble();
            double valueB = this.exprB.getDouble();
            this.exists = this.exprA.exists() && this.exprB.exists();
            return this.exists ? this.comp.apply(Double.compare(valueA, valueB)) : false;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    @FunctionalInterface
    public static interface CompResultFunction {
        public boolean apply(int var1);
    }

    public static class LTEFunction {
        public static final String name = "lte";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val <= 0, params);
    }

    public static class LTFunction {
        public static final String name = "lt";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val < 0, params);
    }

    public static class GTEFunction {
        public static final String name = "gte";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val >= 0, params);
    }

    public static class GTFunction {
        public static final String name = "gt";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val > 0, params);
    }
}

