/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.people.kafka.KafkaConfiguration;
import de.justsoftware.people.kafka.KafkaConfigurationProvider;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u0006H\u0017\u00a8\u0006\r"}, d2={"Lde/justsoftware/people/kafka/KafkaConfiguration;", "", "<init>", "()V", "createStringProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "kafkaConfigurationProvider", "Lde/justsoftware/people/kafka/KafkaConfigurationProvider;", "admin", "Lorg/springframework/kafka/core/KafkaAdmin;", "bootstrapServers", "ClosingKafkaProducer", "people-api"})
public class KafkaConfiguration {
    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> createStringProducer(@NotNull KafkaConfigurationProvider kafkaConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)kafkaConfigurationProvider, (String)"kafkaConfigurationProvider");
        Properties props = kafkaConfigurationProvider.producerConfig();
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(props), arg_0 -> KafkaConfiguration.createStringProducer$lambda$0(kafkaConfigurationProvider, arg_0));
    }

    @Bean
    @NotNull
    public KafkaAdmin admin(@Value(value="${spring.kafka.bootstrapServers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        Map configs = (Map)immutableMap;
        KafkaAdmin admin = new KafkaAdmin(configs);
        admin.setFatalIfBrokerNotAvailable(true);
        return admin;
    }

    private static final Consumer createStringProducer$lambda$0(KafkaConfigurationProvider $kafkaConfigurationProvider, TopicPartition tp) {
        Intrinsics.checkNotNullParameter((Object)tp, (String)"tp");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)$kafkaConfigurationProvider.consumerConfig(null));
    }
}

