/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.authorization;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.permission.client.PermissionOffsetChecker;
import de.justsoftware.permission.client.kafka.PermissionItemKafkaProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentKafkaProducer;
import de.justsoftware.permission.client.rest.JustPermissionRequestConnector;
import java.time.Clock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class JustPermissionConfig {
    @Nonnull
    @Bean
    public JustPermissionRequestConnector permissionRequestConnector(@Value(value="${just-permission.api.url}") String permissionApiUrl, RestTemplateBuilder restTemplateBuilder) {
        return new JustPermissionRequestConnector(permissionApiUrl, restTemplateBuilder.build());
    }

    @Nonnull
    @Bean
    public SingleRoleAssignmentKafkaProducer singleRoleAssignmentKafkaProducer(@Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> kafkaProducer, PermissionOffsetChecker permissionOffsetChecker, Clock clock) {
        return new SingleRoleAssignmentKafkaProducer(kafkaProducer, permissionOffsetChecker, clock);
    }

    @Nonnull
    @Bean
    public PermissionItemProducer permissionItemProducer(@Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> kafkaProducer, PermissionOffsetChecker permissionOffsetChecker, Clock clock) {
        return new PermissionItemKafkaProducer(kafkaProducer, permissionOffsetChecker, clock);
    }
}

