/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.controller;

import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.mobile.model.MobilePlatform;
import de.justsoftware.notificationservice.mobile.model.MobilePushToken;
import de.justsoftware.notificationservice.mobile.service.MobilePushTokenService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mobilepush"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0017J<\u0010\u000e\u001a\u00020\u00072\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/notificationservice/mobile/controller/MobilePushController;", "", "mobilePushTokenService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;)V", "registerAndroid", "Lde/justsoftware/notificationservice/mobile/model/MobilePushToken;", "publicKey", "", "mobilePlatformVersion", "pushToken", "authContext", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "registerIos", "silenceAlerts", "", "unregister", "", "mobilePlatform", "notification-service"})
public class MobilePushController {
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;

    public MobilePushController(@NotNull MobilePushTokenService mobilePushTokenService) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        this.mobilePushTokenService = mobilePushTokenService;
    }

    @PostMapping(value={"/android"})
    @NotNull
    public MobilePushToken registerAndroid(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestParam(value="mobilePlatformVersion") @Nullable String mobilePlatformVersion, @RequestBody @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        char[] cArray = new char[]{'\"'};
        return MobilePushTokenService.registerPushToken$default((MobilePushTokenService)this.mobilePushTokenService, (String)StringsKt.trim((String)pushToken, (char[])cArray), (MobilePlatform)MobilePlatform.ANDROID, (String)mobilePlatformVersion, (String)publicKey, (AuthorizationContext)authContext, (boolean)false, (int)32, null);
    }

    @PostMapping(value={"/ios"})
    @NotNull
    public MobilePushToken registerIos(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestParam(value="silenceAlerts", defaultValue="false") boolean silenceAlerts, @RequestParam(value="mobilePlatformVersion") @Nullable String mobilePlatformVersion, @RequestBody @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        char[] cArray = new char[]{'\"'};
        return this.mobilePushTokenService.registerPushToken(StringsKt.trim((String)pushToken, (char[])cArray), MobilePlatform.IOS, mobilePlatformVersion, publicKey, authContext, silenceAlerts);
    }

    @DeleteMapping(value={"/{mobilePlatform:android|ios}/{pushToken}"})
    public void unregister(@PathVariable(value="mobilePlatform") @NotNull String mobilePlatform, @PathVariable(value="pushToken") @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobilePushTokenService.unregisterPushToken(pushToken, MobilePlatform.Companion.toMobilePlatform(mobilePlatform), authContext);
    }
}

