--liquibase formatted sql

--changeset vpphan:create_initial_notification_table
CREATE TABLE notification (
    id ${uuid} NOT NULL PRIMARY KEY,
    app ${varchar64} NOT NULL,
    default_title ${varchar255} NOT NULL,
    default_text ${text} NOT NULL,
    default_secondary_text ${text},
    target_id ${varchar64},
    payload ${text},
    type ${varchar64} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    timestamp ${timestamp} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

CREATE TABLE delivery_status (
    notification_id ${uuid} NOT NULL,
    receiver_id ${varchar64} NOT NULL,
    status ${varchar64} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL,
    PRIMARY KEY (notification_id, receiver_id),
    CONSTRAINT delivery_status_notifi_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_title (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    title ${varchar255} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_title_notification_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_text (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    text ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_text_notification_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_secondary_text (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    secondary_text ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_sec_text_notifi_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

--changeset tsubklewe:update_app_to app_id

ALTER TABLE notification RENAME COLUMN app to app_id;

--changeset tsubklewe:add column mailed to delivery_status / just-20630

ALTER TABLE delivery_status ADD should_trigger_mail ${bool} DEFAULT ${true} NOT NULL;

--changeset vpphan:delete all notifications to start a clean migration of old notifications / JUST-20585

DELETE FROM notification;

--changeset vpphan:migrate_clob_to_text dbms:postgresql

UPDATE localized_text SET text = convert_from(loread(lo_open(text::int, x'40000'::int), x'40000'::int), 'UTF-8');

UPDATE localized_secondary_text SET secondary_text = convert_from(loread(lo_open(secondary_text::int, x'40000'::int), x'40000'::int), 'UTF-8');

UPDATE notification SET
   default_text = convert_from(loread(lo_open(default_text::int, x'40000'::int), x'40000'::int), 'UTF-8'),
   default_secondary_text = convert_from(loread(lo_open(default_secondary_text::int, x'40000'::int), x'40000'::int), 'UTF-8'),
   payload = convert_from(loread(lo_open(payload::int, x'40000'::int), x'40000'::int), 'UTF-8');

SELECT lo_unlink(l.oid) FROM pg_largeobject_metadata l;

--changeset vpphan:add_delivery_status_rec_stat_idx

CREATE INDEX delivery_status_rec_stat_idx ON delivery_status(receiver_id, status);

--changeset azottnick:add_column_to_mark_delivery_status

ALTER TABLE delivery_status ADD marked ${bool} DEFAULT ${false} NOT NULL;

--changeset vpphan:add_index_to_improve_performance

CREATE INDEX delivery_status_receiver_idx ON delivery_status(receiver_id);
CREATE INDEX delivery_status_status_idx ON delivery_status(status);
CREATE INDEX delivery_status_rec_update_idx ON delivery_status(receiver_id, updated_at);
CREATE INDEX notification_timestamp_idx ON notification(timestamp);

--changeset tsubklewe:add_index_to_improve_performance

CREATE INDEX notification_type_idx ON notification(type);

--changeset tsubklewe:add_index_to_improve_app_filter_performance

CREATE INDEX notification_app_id_idx ON notification(app_id);

--changeset azottnick:create_user_group_table

CREATE TABLE user_group_member (
    PRIMARY KEY (group_id, profile_id),
    group_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

CREATE INDEX user_group_member_group_id_idx ON user_group_member(group_id);

--changeset azottnick:add_mail_author_container_and_replacement_text

ALTER TABLE notification ADD mail_author_name ${text};
ALTER TABLE notification ADD default_mail_container_name ${text};
ALTER TABLE notification ADD default_mail_replacement_text ${text};

CREATE TABLE localized_mail_container_name (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    mail_container_name ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_mail_con_nam_noti_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_mail_replacement_text (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    mail_replacement_text ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_mail_repl_text_noti_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

--changeset aliivanurm:delete_all_archivednews_notifications

DELETE FROM notification WHERE app_id = 'archivednews';

--changeset holger.dewes:add_mobile_push_token
CREATE TABLE mobile_push_token (
    PRIMARY KEY (token, platform),
    token ${varchar255} NOT NULL,
    platform ${varchar64} NOT NULL,
    profile_id ${int64} NOT NULL,
    locale ${varchar16} NOT NULL,
    ios_silence_alerts ${bool} DEFAULT ${false} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
CREATE INDEX mobile_push_token_profile_id_idx ON mobile_push_token(profile_id);

--changeset holger.dewes:add_public_key_to_mobile_push_token
ALTER TABLE mobile_push_token ADD public_key ${varchar1024};

--changeset alexander.zottnick:delete_entity_related_notifications
DELETE FROM notification WHERE type IN ('INVITED_USER_REGISTERED','INVITATION','ENTITY_WILL_GET_ARCHIVED','VERSION_RELEASE_REQUEST','VERSION_RELEASE_REQUEST_DECLINED','VERSION_RELEASE_REQUEST_ACCEPTED','ENTITY_JOIN_REQUEST','RECOMMENDATION_NOTIFICATION','RECOMMENDATION_TASK_ASSIGNED','ADDED_TO_TASK_LIST','TASK_ASSIGNED','NEW_VERSION_PUBLISHED_ON_SUBSCRIPTION','NEW_ENTITY_PUBLISHED_ON_PARENT_SUBSCRIPTION');

--changeset holger.dewes:add_mobile_os_version_tracking
ALTER TABLE mobile_push_token RENAME platform TO mobile_platform;
ALTER TABLE mobile_push_token ADD mobile_platform_version ${varchar255};

--changeset holger.dewes:add_deleted_delivery_status_for_sync
CREATE TABLE deleted_delivery_status_for_sync (
    notification_id ${uuid} NOT NULL,
    receiver_id ${varchar64} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL,
    PRIMARY KEY (notification_id, receiver_id)
);
CREATE INDEX deleted_delivery_status_for_sync_receiver_id_updated_at_idx ON deleted_delivery_status_for_sync(receiver_id, updated_at);
