/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import de.justsoftware.notificationservice.mobile.persistence.DeletedDeliveryStatusForSyncRepository;
import de.justsoftware.notificationservice.mobile.service.DeletedDeliveryStatusForSyncCleanupService;
import de.justsoftware.notificationservice.mobile.service.MobileSyncService;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/notificationservice/mobile/service/DeletedDeliveryStatusForSyncCleanupService;", "", "deletedDeliveryStatusForSyncRepository", "Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;Ljava/time/Clock;)V", "cleanObsoleteEntries", "", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nDeletedDeliveryStatusForSyncCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeletedDeliveryStatusForSyncCleanupService.kt\nde/justsoftware/notificationservice/mobile/service/DeletedDeliveryStatusForSyncCleanupService\n+ 2 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,31:1\n8#2:32\n7#2,3:33\n*S KotlinDebug\n*F\n+ 1 DeletedDeliveryStatusForSyncCleanupService.kt\nde/justsoftware/notificationservice/mobile/service/DeletedDeliveryStatusForSyncCleanupService\n*L\n28#1:32\n28#1:33,3\n*E\n"})
public class DeletedDeliveryStatusForSyncCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusForSyncRepository;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Logger LOG;

    public DeletedDeliveryStatusForSyncCleanupService(@NotNull DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusForSyncRepository, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)deletedDeliveryStatusForSyncRepository, (String)"deletedDeliveryStatusForSyncRepository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.deletedDeliveryStatusForSyncRepository = deletedDeliveryStatusForSyncRepository;
        this.clock = clock;
    }

    @Scheduled(fixedRate=24L, initialDelay=2L, timeUnit=TimeUnit.HOURS)
    @Transactional
    public void cleanObsoleteEntries() {
        Instant deleteBeforeDate = this.clock.instant().minus(MobileSyncService.Companion.getCHANGES_MAX_AGE());
        LOG.info("Start deleting deleted delivery status entries from before " + deleteBeforeDate);
        Intrinsics.checkNotNull((Object)deleteBeforeDate);
        long deletedCount = this.deletedDeliveryStatusForSyncRepository.deleteByCreatedAtLessThan(deleteBeforeDate);
        LOG.info("Deleted " + deletedCount + " deleted delivery status entries");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

