/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.model.Notification;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.NotificationsCount;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import io.swagger.v3.oas.annotations.Operation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/notification"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JV\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001a\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001a\u0010\u001d\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001a\u0010\u001e\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010\u001f\u001a\u00020\u00182\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J*\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010$2\b\b\u0001\u0010%\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/notificationservice/controller/NotificationController;", "", "notificationService", "Lde/justsoftware/notificationservice/business/NotificationService;", "pollIntervalMs", "", "<init>", "(Lde/justsoftware/notificationservice/business/NotificationService;I)V", "getNotifications", "", "Lde/justsoftware/notificationservice/model/Notification;", "locale", "", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "date", "Ljava/time/LocalDateTime;", "maxElements", "concern", "Lde/justsoftware/notificationclient/model/NotificationConcern;", "app", "authContext", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "archiveNotification", "", "notificationId", "Ljava/util/UUID;", "archiveAllNotifications", "", "markNotification", "unmarkNotification", "moveToOpen", "notificationIds", "notificationsCount", "Lde/justsoftware/notificationservice/model/NotificationsCount;", "updatedSince", "", "since", "notification-service"})
public class NotificationController {
    @NotNull
    private final NotificationService notificationService;
    private final int pollIntervalMs;

    public NotificationController(@NotNull NotificationService notificationService, @Value(value="${service.pollIntervalMs:300000}") int pollIntervalMs) {
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        this.notificationService = notificationService;
        this.pollIntervalMs = pollIntervalMs;
    }

    @Operation(summary="Return localized notifications for the current user", description="Only notification with the given status and before the given date are returned. If date isn't given, the current time will be used.")
    @GetMapping(value={""})
    @NotNull
    public List<Notification> getNotifications(@RequestParam(name="locale", defaultValue="en") @NotNull String locale, @RequestParam(name="status", defaultValue="OPEN") @NotNull NotificationStatus status, @RequestParam(value="date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) @Nullable LocalDateTime date, @RequestParam(value="maxElements", defaultValue="20") int maxElements, @RequestParam(value="concern", required=false, defaultValue="ALL") @NotNull NotificationConcern concern, @RequestParam(value="app", required=false) @Nullable String app, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Locale locale2 = Locale.forLanguageTag(locale);
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"forLanguageTag(...)");
        ProfileId profileId = authContext.getProfileId();
        Comparable<ChronoLocalDateTime<?>> comparable = date;
        if (comparable == null || (comparable = comparable.toInstant(ZoneOffset.UTC)) == null) {
            comparable = Instant.now();
        }
        Comparable<ChronoLocalDateTime<?>> comparable2 = comparable;
        Intrinsics.checkNotNull((Object)comparable2);
        return this.notificationService.getNotifications(locale2, profileId, status, concern, app, (Instant)comparable2, maxElements);
    }

    @Operation(summary="Move notification into archive")
    @PutMapping(value={"/archive/{notificationId}"})
    public void archiveNotification(@PathVariable @NotNull UUID notificationId, @NotNull AuthorizationContext authContext) {
        Object $this$archiveNotification_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        NotificationController notificationController = this;
        try {
            $this$archiveNotification_u24lambda_u240 = notificationController;
            boolean bl = false;
            $this$archiveNotification_u24lambda_u240.notificationService.archiveNotification(notificationId, authContext.getProfileId());
            $this$archiveNotification_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$archiveNotification_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        notificationController = $this$archiveNotification_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)notificationController);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", e);
        }
    }

    @Operation(summary="Archive all unread and unmarked notifications.", description="Returns the ids of the modified notifications.")
    @PutMapping(value={"/archive"})
    @NotNull
    public Set<UUID> archiveAllNotifications(@RequestParam(value="concern", required=false, defaultValue="ALL") @NotNull NotificationConcern concern, @RequestParam(value="app", required=false) @Nullable String app, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.notificationService.archiveAllUnmarkedNotifications(authContext.getProfileId(), concern, app);
    }

    @Operation(summary="Setting a marker for a specific notification and move its status to OPEN if it was previously ARCHIVED")
    @PutMapping(value={"/{notificationId}/mark"})
    public void markNotification(@PathVariable @NotNull UUID notificationId, @NotNull AuthorizationContext authContext) {
        Object $this$markNotification_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        NotificationController notificationController = this;
        try {
            $this$markNotification_u24lambda_u242 = notificationController;
            boolean bl = false;
            $this$markNotification_u24lambda_u242.notificationService.markNotification(notificationId, authContext.getProfileId());
            $this$markNotification_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$markNotification_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        notificationController = $this$markNotification_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)notificationController);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", e);
        }
    }

    @Operation(summary="Remove a previously set marker from a specific notification")
    @PutMapping(value={"/{notificationId}/unmark"})
    public void unmarkNotification(@PathVariable @NotNull UUID notificationId, @NotNull AuthorizationContext authContext) {
        Object $this$unmarkNotification_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        NotificationController notificationController = this;
        try {
            $this$unmarkNotification_u24lambda_u244 = notificationController;
            boolean bl = false;
            $this$unmarkNotification_u24lambda_u244.notificationService.unmarkNotification(notificationId, authContext.getProfileId());
            $this$unmarkNotification_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$unmarkNotification_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        notificationController = $this$unmarkNotification_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)notificationController);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", e);
        }
    }

    @Operation(summary="Set the status of the provided notifications to OPEN")
    @PutMapping(value={"/open"})
    public void moveToOpen(@RequestBody @NotNull List<UUID> notificationIds, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.notificationService.moveToOpen(notificationIds, authContext.getProfileId());
    }

    @Operation(summary="Return count of open and archived notifications")
    @GetMapping(value={"/count"})
    @NotNull
    public NotificationsCount notificationsCount(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.notificationService.getNotificationsCount(authContext.getProfileId());
    }

    @Operation(summary="Return whether there were changes since a specific date")
    @GetMapping(value={"/updated"})
    @NotNull
    public Map<String, Object> updatedSince(@RequestParam(value="since") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) @NotNull LocalDateTime since, @NotNull AuthorizationContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$updatedSince_u24lambda_u246 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        ProfileId profileId = authContext.getProfileId();
        Instant instant = since.toInstant(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        $this$updatedSince_u24lambda_u246.putAll(this.notificationService.updated(profileId, instant));
        $this$updatedSince_u24lambda_u246.put("nextPollIntervalMs", this.pollIntervalMs);
        return MapsKt.build((Map)map);
    }
}

