/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.config;

import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.notificationservice.NotificationServiceConfiguration;
import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.config.AuthorizationContextResolver;
import de.justsoftware.notificationservice.exception.UnauthorizedException;
import de.justsoftware.notificationservice.model.TenantId;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/notificationservice/config/AuthorizationContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "localeResolver", "Lorg/springframework/web/servlet/LocaleResolver;", "<init>", "(Lorg/springframework/web/servlet/LocaleResolver;)V", "supportsParameter", "", "parameter", "Lorg/springframework/core/MethodParameter;", "resolveArgument", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "profileId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "getProfileId", "(Lde/justsoftware/jwtfilter/JwtAuthenticationToken;)Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "tenantId", "Lde/justsoftware/notificationservice/model/TenantId;", "getTenantId", "(Lde/justsoftware/jwtfilter/JwtAuthenticationToken;)Lde/justsoftware/notificationservice/model/TenantId;", "resolveLocale", "Ljava/util/Locale;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/notificationservice/config/AuthorizationContextResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,81:1\n1#2:82\n8#3:83\n7#3,3:84\n*S KotlinDebug\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/notificationservice/config/AuthorizationContextResolver\n*L\n78#1:83\n78#1:84,3\n*E\n"})
public final class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LocaleResolver localeResolver;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContextResolver(@NotNull LocaleResolver localeResolver) {
        Intrinsics.checkNotNullParameter((Object)localeResolver, (String)"localeResolver");
        this.localeResolver = localeResolver;
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthorizationContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthorizationContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        if (!(authentication2 instanceof JwtAuthenticationToken)) {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return new AuthorizationContext(this.getProfileId((JwtAuthenticationToken)authentication2), this.getTenantId((JwtAuthenticationToken)authentication2), this.resolveLocale(webRequest));
    }

    private final ProfileId getProfileId(JwtAuthenticationToken $this$profileId) {
        Object $this$_get_profileId__u24lambda_u240;
        JwtAuthenticationToken jwtAuthenticationToken = $this$profileId;
        try {
            $this$_get_profileId__u24lambda_u240 = jwtAuthenticationToken;
            boolean bl = false;
            $this$_get_profileId__u24lambda_u240 = Result.constructor-impl((Object)new ProfileId($this$_get_profileId__u24lambda_u240.getPrincipal()));
        }
        catch (Throwable bl) {
            $this$_get_profileId__u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        jwtAuthenticationToken = $this$_get_profileId__u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)jwtAuthenticationToken);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            LOG.warn("We received an unparsable profile ID: '" + $this$profileId.getPrincipal() + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return (ProfileId)jwtAuthenticationToken;
    }

    private final TenantId getTenantId(JwtAuthenticationToken $this$tenantId) throws UnauthorizedException {
        Object $this$_get_tenantId__u24lambda_u242;
        Object object = $this$tenantId.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId = object;
        JwtAuthenticationToken jwtAuthenticationToken = $this$tenantId;
        try {
            $this$_get_tenantId__u24lambda_u242 = jwtAuthenticationToken;
            boolean bl = false;
            $this$_get_tenantId__u24lambda_u242 = Result.constructor-impl((Object)TenantId.Companion.fromCanonicalId(tenantId.toString()));
        }
        catch (Throwable bl) {
            $this$_get_tenantId__u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        jwtAuthenticationToken = $this$_get_tenantId__u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)jwtAuthenticationToken);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            LOG.warn("We received an unparsable tenant ID: '" + tenantId + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return (TenantId)jwtAuthenticationToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Locale resolveLocale(NativeWebRequest $this$resolveLocale) {
        Locale locale;
        HttpServletRequest httpServletRequest = (HttpServletRequest)$this$resolveLocale.getNativeRequest(HttpServletRequest.class);
        if (httpServletRequest != null) {
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            LocaleResolver localeResolver = this.localeResolver;
            HttpServletRequest p0 = httpServletRequest2;
            boolean bl = false;
            Locale locale2 = localeResolver.resolveLocale(p0);
            if (locale2 != null) {
                locale = locale2;
                return locale;
            }
        }
        locale = NotificationServiceConfiguration.Companion.getDEFAULT_LOCALE();
        return locale;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

