/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.drive;

import de.justsoftware.wikiservice.drive.DriveAPI;
import de.justsoftware.wikiservice.drive.model.InternalFileModel;
import de.justsoftware.wikiservice.model.ProfileId;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/wikiservice/drive/DriveService;", "", "driveApi", "Lde/justsoftware/wikiservice/drive/DriveAPI;", "<init>", "(Lde/justsoftware/wikiservice/drive/DriveAPI;)V", "getDriveApi", "()Lde/justsoftware/wikiservice/drive/DriveAPI;", "persistFiles", "", "", "Lde/justsoftware/wikiservice/drive/model/InternalFileModel;", "ids", "", "targetId", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "persistFile", "id", "wiki-service"})
public class DriveService {
    @NotNull
    private final DriveAPI driveApi;

    public DriveService(@NotNull DriveAPI driveApi) {
        Intrinsics.checkNotNullParameter((Object)driveApi, (String)"driveApi");
        this.driveApi = driveApi;
    }

    @NotNull
    public DriveAPI getDriveApi() {
        return this.driveApi;
    }

    @NotNull
    public Map<String, InternalFileModel> persistFiles(@NotNull Set<String> ids, @NotNull String targetId, @NotNull ProfileId creator) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        return this.getDriveApi().persistFiles(ids, targetId, creator);
    }

    @NotNull
    public InternalFileModel persistFile(@NotNull String id, @NotNull String targetId, @NotNull ProfileId creator) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Object v = this.persistFiles(SetsKt.setOf((Object)id), targetId, creator).get(id);
        if (v == null) {
            boolean bl = false;
            String string = "Failed to persist file with id=" + id;
            throw new IllegalStateException(string.toString());
        }
        return (InternalFileModel)v;
    }
}

