/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchResponse;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.wikiservice.application.SearchApplicationService;
import de.justsoftware.wikiservice.authorization.AuthContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/search"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/controller/SearchController;", "", "searchApplicationService", "Lde/justsoftware/wikiservice/application/SearchApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/SearchApplicationService;)V", "searchDriveDocuments", "Lde/justsoftware/search/shared/model/SearchResponse;", "query", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "searchWikiElements", "wiki-service"})
public class SearchController {
    @NotNull
    private final SearchApplicationService searchApplicationService;

    public SearchController(@NotNull SearchApplicationService searchApplicationService) {
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        this.searchApplicationService = searchApplicationService;
    }

    @GetMapping(value={"driveDocuments"})
    @NotNull
    public SearchResponse searchDriveDocuments(@RequestParam(value="query", required=false, defaultValue="") @NotNull String query, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchApplicationService.searchDriveDocuments(ProfileId.Companion.fromCanonicalId(authContext.getUser().toString()), TenantId.Companion.fromCanonicalId(authContext.getTenantId().toString()), query);
    }

    @GetMapping(value={"wikiElements"})
    @NotNull
    public SearchResponse searchWikiElements(@RequestParam(value="query", required=false, defaultValue="") @NotNull String query, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchApplicationService.searchWikiElements(ProfileId.Companion.fromCanonicalId(authContext.getUser().toString()), TenantId.Companion.fromCanonicalId(authContext.getTenantId().toString()), query);
    }
}

