/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/wikiservice/config/security/WebSecurityConfiguration;", "", "<init>", "()V", "internalApi", "", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "wiki-service"})
public class WebSecurityConfiguration {
    @NotNull
    private final String internalApi;

    public WebSecurityConfiguration() {
        this.internalApi = "/internal/**";
    }

    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        JwtAuthenticationProcessingFilter jwt = new JwtAuthenticationProcessingFilter(jwtVerifier);
        jwt.applyIgnoreFilterMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(this.internalApi));
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$1).headers(WebSecurityConfiguration::configureSecurity$lambda$2).anonymous(Customizer.withDefaults()).authorizeHttpRequests(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$3(this, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void configureSecurity$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$3(WebSecurityConfiguration this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        RequestMatcher[] requestMatcherArray = new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher(this$0.internalApi)};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(requestMatcherArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }
}

