/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.config.AuthContextResolver;
import de.justsoftware.wikiservice.exception.UnauthorizedException;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/config/AuthContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "<init>", "(Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;)V", "supportsParameter", "", "parameter", "Lorg/springframework/core/MethodParameter;", "resolveArgument", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "profileId", "Lde/justsoftware/wikiservice/model/ProfileId;", "authentication", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAuthContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthContextResolver.kt\nde/justsoftware/wikiservice/config/AuthContextResolver\n+ 2 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,88:1\n8#2:89\n7#2,3:90\n*S KotlinDebug\n*F\n+ 1 AuthContextResolver.kt\nde/justsoftware/wikiservice/config/AuthContextResolver\n*L\n85#1:89\n85#1:90,3\n*E\n"})
public final class AuthContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private static final Logger LOG;

    public AuthContextResolver(@NotNull AuthorizationService authService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.authService = authService;
        this.wikiService = wikiService;
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        if (!(authentication2 instanceof JwtAuthenticationToken)) {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return new AuthContext(this.profileId((JwtAuthenticationToken)authentication2), this.tenantId((JwtAuthenticationToken)authentication2), this.authService, this.wikiService);
    }

    private final ProfileId profileId(JwtAuthenticationToken authentication) {
        ProfileId profileId;
        String principal = authentication.getPrincipal().toString();
        try {
            profileId = new ProfileId(principal);
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable profile ID: '" + principal + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final TenantId tenantId(JwtAuthenticationToken authentication) {
        TenantId tenantId;
        Object object = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId2 = object;
        try {
            tenantId = new TenantId(tenantId2.toString());
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable tenant ID: '" + tenantId2 + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

