/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.kafka.MultiRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsetException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.model.Article;
import de.justsoftware.wikiservice.business.model.Permission;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiPermissionModifiedEvent;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.PermissionRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.DbArticle;
import de.justsoftware.wikiservice.persistence.model.DbPermission;
import de.justsoftware.wikiservice.persistence.model.DbWiki;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.KotlinUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 =2\u00020\u0001:\u0002<=B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0017J0\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0%0(H\u0012J\"\u0010*\u001a\u00020\u00172\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0%0(H\u0012J0\u0010+\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0%0(H\u0017J\b\u0010,\u001a\u00020\u0017H\u0016J\b\u0010-\u001a\u00020\u0017H\u0012J\u0016\u0010.\u001a\u00020\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0012J\u0016\u00102\u001a\u00020\u00172\f\u00103\u001a\b\u0012\u0004\u0012\u00020400H\u0012J(\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0(2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001b00H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u00108\u001a\u00020\u00172\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0%H\u0012J\u0016\u0010;\u001a\u00020\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001b00H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006>"}, d2={"Lde/justsoftware/wikiservice/business/PermissionService;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "multiRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "permissionRepository", "Lde/justsoftware/wikiservice/persistence/PermissionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;Lde/justsoftware/permission/client/kafka/PermissionItemProducer;Lde/justsoftware/wikiservice/persistence/PermissionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "addPermissionItemForNewArticle", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "addPermissionItemForNewWiki", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "removePermissionsForDeletedWiki", "removePermissionsForDeletedArticle", "deletePermissionsForGrantee", "granteeId", "Lde/justsoftware/wikiservice/model/GranteeId;", "createPermissions", "", "Lde/justsoftware/wikiservice/business/model/Permission;", "permissions", "", "Lde/justsoftware/wikiservice/model/PermissionType;", "validatePermissions", "setPermissions", "republishPermissions", "republishRoles", "republishWikiItems", "wikis", "", "Lde/justsoftware/wikiservice/business/model/Wiki;", "republishArticleItems", "articles", "Lde/justsoftware/wikiservice/business/model/Article;", "getPermissionsByWikiIds", "wikiIds", "getPermissionsByWikiId", "executePermissionInstructions", "instructions", "Lde/justsoftware/wikiservice/business/PermissionService$PermissionInstruction;", "removePermissionsForWikis", "PermissionInstruction", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nPermissionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionService.kt\nde/justsoftware/wikiservice/business/PermissionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,355:1\n1557#2:356\n1628#2,3:357\n1557#2:360\n1628#2,3:361\n1557#2:367\n1628#2,3:368\n1557#2:374\n1628#2,3:375\n774#2:378\n865#2,2:379\n1628#2,3:382\n1628#2,3:386\n1628#2,3:390\n1279#2,2:393\n1293#2,2:395\n1557#2:397\n1628#2,3:398\n1296#2:401\n1557#2:402\n1628#2,3:403\n1863#2,2:406\n1628#2,3:409\n1187#2,2:412\n1261#2,4:414\n1863#2,2:418\n1557#2:423\n1628#2,3:424\n1557#2:428\n1628#2,3:429\n1863#2:432\n1864#2:440\n1485#2:441\n1510#2,3:442\n1513#2,3:452\n1246#2,2:457\n1557#2:459\n1628#2,3:460\n1249#2:463\n1863#2,2:464\n1863#2,2:466\n77#3:364\n97#3,2:365\n99#3,3:371\n126#3:420\n153#3,2:421\n155#3:427\n7#4:381\n7#4:385\n7#4:389\n7#4:408\n381#5,7:433\n381#5,7:445\n462#5:455\n412#5:456\n*S KotlinDebug\n*F\n+ 1 PermissionService.kt\nde/justsoftware/wikiservice/business/PermissionService\n*L\n144#1:356\n144#1:357,3\n147#1:360\n147#1:361,3\n166#1:367\n166#1:368,3\n175#1:374\n175#1:375,3\n182#1:378\n182#1:379,2\n235#1:382,3\n236#1:386,3\n298#1:390,3\n299#1:393,2\n299#1:395,2\n300#1:397\n300#1:398,3\n299#1:401\n307#1:402\n307#1:403,3\n312#1:406,2\n347#1:409,3\n100#1:412,2\n100#1:414,4\n154#1:418,2\n210#1:423\n210#1:424,3\n215#1:428\n215#1:429,3\n216#1:432\n216#1:440\n253#1:441\n253#1:442,3\n253#1:452,3\n259#1:457,2\n260#1:459\n260#1:460,3\n259#1:463\n273#1:464,2\n288#1:466,2\n165#1:364\n165#1:365,2\n165#1:371,3\n206#1:420\n206#1:421,2\n206#1:427\n235#1:381\n236#1:385\n298#1:389\n347#1:408\n217#1:433,7\n253#1:445,7\n259#1:455\n259#1:456\n*E\n"})
public class PermissionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final MultiRoleAssignmentProducer multiRoleAssignmentProducer;
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private final PermissionRepository permissionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Logger log;

    public PermissionService(@NotNull WikiRepository wikiRepository, @NotNull ArticleRepository articleRepository, @NotNull MultiRoleAssignmentProducer multiRoleAssignmentProducer, @NotNull PermissionItemProducer permissionItemProducer, @NotNull PermissionRepository permissionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)multiRoleAssignmentProducer, (String)"multiRoleAssignmentProducer");
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.wikiRepository = wikiRepository;
        this.articleRepository = articleRepository;
        this.multiRoleAssignmentProducer = multiRoleAssignmentProducer;
        this.permissionItemProducer = permissionItemProducer;
        this.permissionRepository = permissionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.log = LoggerFactory.getLogger(PermissionService.class);
    }

    @Transactional
    public void addPermissionItemForNewArticle(@NotNull ArticleId articleId, @NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.transactionUtils.afterCommit(() -> PermissionService.addPermissionItemForNewArticle$lambda$0(this, articleId, wikiId));
    }

    @Transactional
    public void addPermissionItemForNewWiki(@NotNull WikiId wikiId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.transactionUtils.afterCommit(() -> PermissionService.addPermissionItemForNewWiki$lambda$1(this, wikiId, tenantId));
    }

    @Transactional
    public void removePermissionsForDeletedWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.transactionUtils.afterCommit(() -> PermissionService.removePermissionsForDeletedWiki$lambda$3(this, wikiId));
    }

    @Transactional
    public void removePermissionsForDeletedArticle(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.transactionUtils.afterCommit(() -> PermissionService.removePermissionsForDeletedArticle$lambda$4(articleId, this));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deletePermissionsForGrantee(@NotNull GranteeId granteeId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List permissionsToRemove = this.permissionRepository.findAllByGranteeId(granteeId.getGranteeId());
        if (permissionsToRemove.isEmpty()) {
            return;
        }
        Iterable iterable = permissionsToRemove;
        boolean $i$f$map22 = false;
        void var6_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DbPermission dbPermission = (DbPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set permissionsIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = permissionsToRemove;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbPermission bl = (DbPermission)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.permissionRepository.deleteAllById(permissionsIds);
        this.transactionUtils.afterCommit(() -> PermissionService.deletePermissionsForGrantee$lambda$8(this, wikiIds));
    }

    /*
     * WARNING - void declaration
     */
    private List<Permission> createPermissions(WikiId wikiId, Map<PermissionType, ? extends List<GranteeId>> permissions) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Map<PermissionType, ? extends List<GranteeId>> $this$flatMap$iv = permissions;
        boolean $i$f$flatMap = false;
        Map<PermissionType, ? extends List<GranteeId>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            PermissionType permissionType = (PermissionType)entry.getKey();
            List granteeIds = (List)entry.getValue();
            Iterable $this$map$iv = granteeIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                GranteeId granteeId = (GranteeId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                UUID uUID = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                collection.add(new DbPermission(uUID, wikiId.getId(), permissionType, it.getGranteeId()));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newPermissions = (List)destination$iv$iv;
        List list = this.permissionRepository.saveAll((Iterable)newPermissions);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"saveAll(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (DbPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(DbPermission.Companion.toPermission((DbPermission)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private void validatePermissions(Map<PermissionType, ? extends List<GranteeId>> permissions) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)permissions.values());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GranteeId it = (GranteeId)element$iv$iv;
            boolean bl = false;
            if (!(!it.isProfileOrUserGroup())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsupportedGranteeIds = (List)destination$iv$iv;
        if (!unsupportedGranteeIds.isEmpty()) {
            boolean bl = false;
            String string = "Following granteeIds are not supported (required User Group or Profile):\n" + unsupportedGranteeIds;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Transactional
    @NotNull
    public List<Permission> setPermissions(@NotNull WikiId wikiId, @NotNull Map<PermissionType, ? extends List<GranteeId>> permissions) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.log.debug("Validating new permissions for " + wikiId);
        this.validatePermissions(permissions);
        this.log.debug("Deleting previous permissions for wiki " + wikiId);
        this.permissionRepository.deleteByWikiId(wikiId.getId());
        this.permissionRepository.flush();
        this.log.debug("Creating new permissions for wiki " + wikiId + " in database");
        List createdPermissions = this.createPermissions(wikiId, permissions);
        this.transactionUtils.afterCommit(() -> PermissionService.setPermissions$lambda$19(this, wikiId, permissions));
        return createdPermissions;
    }

    /*
     * WARNING - void declaration
     */
    public void republishPermissions() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapToSet$iv = list;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DbWiki dbWiki = (DbWiki)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(DbWiki.Companion.toWiki((DbWiki)it));
        }
        Set wikis = (Set)destination$iv$iv;
        List list2 = this.articleRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findAll(...)");
        Iterable $this$mapToSet$iv2 = list2;
        boolean $i$f$mapToSet2 = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbArticle bl = (DbArticle)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(DbArticle.Companion.toArticle((DbArticle)it));
        }
        Set articles = (Set)destination$iv$iv2;
        this.log.debug("Republishing permission items for wikis");
        this.republishWikiItems(wikis);
        this.republishArticleItems(articles);
        this.log.debug("Republishing role replacements");
        this.republishRoles();
    }

    private void republishRoles() {
        this.multiRoleAssignmentProducer.republishForAllItemRoles("WIKI_WIKI", () -> PermissionService.republishRoles$lambda$25(this));
    }

    private void republishWikiItems(Set<Wiki> wikis) {
        this.permissionItemProducer.republish("WIKI_WIKI", () -> PermissionService.republishWikiItems$lambda$27(wikis, this));
    }

    private void republishArticleItems(Set<Article> articles) {
        this.permissionItemProducer.republish("WIKI_ARTICLE", () -> PermissionService.republishArticleItems$lambda$29(articles, this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, List<Permission>> getPermissionsByWikiIds(@NotNull Set<WikiId> wikiIds) {
        WikiId it;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        Object object = this.permissionRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WikiId wikiId = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map permissions = object.findAllByWikiIds((Set)destination$iv$iv);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void wikiId;
            it = (WikiId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable $this$map$iv = permissions.getOrDefault(wikiId, CollectionsKt.emptyList());
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                DbPermission dbPermission = (DbPermission)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(DbPermission.Companion.toPermission((DbPermission)it2));
            }
            List list = (List)destination$iv$iv2;
            object.put(collection, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Permission> getPermissionsByWikiId(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$map$iv = this.permissionRepository.findAllByWikiIds(SetsKt.setOf((Object)wikiId.getId())).getOrDefault(wikiId, CollectionsKt.emptyList());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbPermission dbPermission = (DbPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbPermission.Companion.toPermission((DbPermission)it));
        }
        return (List)destination$iv$iv;
    }

    private void executePermissionInstructions(List<? extends PermissionInstruction> instructions) {
        Stream.Builder<WaitForOffsets> offsetConsumer = Stream.builder();
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PermissionInstruction it = (PermissionInstruction)element$iv;
            boolean bl = false;
            PermissionInstruction permissionInstruction = it;
            if (permissionInstruction instanceof PermissionInstruction.AddWikiInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishItem(((PermissionInstruction.AddWikiInstruction)it).getWikiId().toString(), Optional.of(((PermissionInstruction.AddWikiInstruction)it).getTenantId().toString()), new String[0]));
            } else if (permissionInstruction instanceof PermissionInstruction.DeleteItemInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishDeletedItem(((PermissionInstruction.DeleteItemInstruction)it).getItemId().toString()));
            } else if (permissionInstruction instanceof PermissionInstruction.PublishReplacementsInstruction) {
                offsetConsumer.accept(this.multiRoleAssignmentProducer.publishRoleReplacements(((PermissionInstruction.PublishReplacementsInstruction)it).getReplacements()));
            } else if (permissionInstruction instanceof PermissionInstruction.AddArticleInstruction) {
                offsetConsumer.accept(this.permissionItemProducer.publishItem(((PermissionInstruction.AddArticleInstruction)it).getArticleId().toString(), Optional.of(((PermissionInstruction.AddArticleInstruction)it).getWikiId().toString()), new String[0]));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            KotlinUtilsKt.getCheckAllMatched((Object)Unit.INSTANCE);
        }
        try {
            new WaitForOffsets(offsetConsumer.build()).waitForOffsets();
        }
        catch (WaitForOffsetException ex) {
            this.log.error("error while waiting for response from permission service", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removePermissionsForWikis(@NotNull Set<WikiId> wikiIds) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        PermissionRepository permissionRepository = this.permissionRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        permissionRepository.deleteAllByWikiIds((Set)destination$iv$iv);
    }

    private static final Unit addPermissionItemForNewArticle$lambda$0(PermissionService this$0, ArticleId $articleId, WikiId $wikiId) {
        this$0.executePermissionInstructions(CollectionsKt.listOf((Object)new PermissionInstruction.AddArticleInstruction($articleId, $wikiId)));
        return Unit.INSTANCE;
    }

    private static final Unit addPermissionItemForNewWiki$lambda$1(PermissionService this$0, WikiId $wikiId, TenantId $tenantId) {
        this$0.executePermissionInstructions(CollectionsKt.listOf((Object)new PermissionInstruction.AddWikiInstruction($wikiId, $tenantId)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit removePermissionsForDeletedWiki$lambda$3(PermissionService this$0, WikiId $wikiId) {
        void $this$associateTo$iv$iv;
        this$0.log.debug("Removing role replacements and item for deleted wiki " + $wikiId);
        Iterable $this$associate$iv = (Iterable)PermissionType.getEntries();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PermissionType type = (PermissionType)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)Companion.permissionRole($wikiId, type), (Object)CollectionsKt.emptyList());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map emptyReplacements = destination$iv$iv;
        Object[] objectArray = new PermissionInstruction[]{new PermissionInstruction.PublishReplacementsInstruction(emptyReplacements), new PermissionInstruction.DeleteItemInstruction((AbstractId)$wikiId)};
        List permissionInstructions = CollectionsKt.listOf((Object[])objectArray);
        this$0.executePermissionInstructions(permissionInstructions);
        return Unit.INSTANCE;
    }

    private static final Unit removePermissionsForDeletedArticle$lambda$4(ArticleId $articleId, PermissionService this$0) {
        List permissionInstructions = CollectionsKt.listOf((Object)new PermissionInstruction.DeleteItemInstruction((AbstractId)$articleId));
        this$0.executePermissionInstructions(permissionInstructions);
        return Unit.INSTANCE;
    }

    private static final Unit deletePermissionsForGrantee$lambda$8(PermissionService this$0, Set $wikiIds) {
        this$0.republishPermissions();
        Iterable $this$forEach$iv = $wikiIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiPermissionModifiedEvent(new WikiId(it)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit setPermissions$lambda$19(PermissionService this$0, WikiId $wikiId, Map $permissions) {
        try {
            void $this$forEach$iv;
            PermissionType entry;
            Collection collection;
            Map.Entry item$iv$iv;
            Object $this$mapTo$iv$iv;
            this$0.log.debug("Publishing new role replacements for wiki " + $wikiId);
            Object $this$map$iv = $permissions;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable = (Iterable)entry.getValue();
                Role role = Companion.permissionRole($wikiId, (PermissionType)entry.getKey());
                boolean $i$f$map2 = false;
                void var16_20 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void g;
                    GranteeId granteeId = (GranteeId)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(g.toRole());
                }
                collection.add(TuplesKt.to((Object)role, (Object)((List)destination$iv$iv2)));
            }
            Map roleReplacements = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
            $this$map$iv = (Iterable)PermissionType.getEntries();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void type;
                item$iv$iv = iterator.next();
                entry = (PermissionType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.permissionRole($wikiId, (PermissionType)type));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Role typeRole = (Role)element$iv;
                boolean bl = false;
                Map $this$getOrPut$iv = roleReplacements;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(typeRole);
                if (value$iv != null) continue;
                boolean bl3 = false;
                List answer$iv = CollectionsKt.emptyList();
                $this$getOrPut$iv.put(typeRole, answer$iv);
            }
            this$0.executePermissionInstructions(CollectionsKt.listOf((Object)new PermissionInstruction.PublishReplacementsInstruction(roleReplacements)));
        }
        finally {
            this$0.log.debug("Publishing permissions modified event for wiki " + $wikiId);
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiPermissionModifiedEvent($wikiId));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void republishRoles$lambda$25(PermissionService this$0) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.permissionRepository.findAllForActiveWikis();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            DbPermission permission = (DbPermission)element$iv$iv;
            boolean bl = false;
            key$iv$iv = Companion.permissionRole(new WikiId(permission.getWikiId()), permission.getType());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void permission;
                DbPermission dbPermission = (DbPermission)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(new GranteeId(permission.getGranteeId()).toRole());
            }
            List list = (List)destination$iv$iv2;
            map2.put(k, list);
        }
        Map roleReplacements = destination$iv$iv;
        this$0.multiRoleAssignmentProducer.publishRoleReplacements(roleReplacements);
    }

    private static final void republishWikiItems$lambda$27(Set $wikis, PermissionService this$0) {
        Iterable $this$forEach$iv = $wikis;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Wiki it = (Wiki)element$iv;
            boolean bl = false;
            this$0.permissionItemProducer.publishItem(it.getId().toString(), Optional.of(it.getTenantId().toString()), new String[0]);
        }
    }

    private static final void republishArticleItems$lambda$29(Set $articles, PermissionService this$0) {
        Iterable $this$forEach$iv = $articles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this$0.permissionItemProducer.publishItem(it.getId().toString(), Optional.of(it.getWikiId().toString()), new String[0]);
        }
    }
}

