/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.model.ConfigId;
import de.justsoftware.wikiservice.model.ConfigType;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.persistence.ConfigRepository;
import de.justsoftware.wikiservice.persistence.model.DbConfig;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/business/ConfigService;", "", "configRepository", "Lde/justsoftware/wikiservice/persistence/ConfigRepository;", "<init>", "(Lde/justsoftware/wikiservice/persistence/ConfigRepository;)V", "setMayReadArticleVersionHistoryPermission", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "permissionType", "Lde/justsoftware/wikiservice/model/PermissionType;", "getMayReadArticleVersionHistoryPermission", "wiki-service"})
public class ConfigService {
    @NotNull
    private final ConfigRepository configRepository;

    public ConfigService(@NotNull ConfigRepository configRepository) {
        Intrinsics.checkNotNullParameter((Object)configRepository, (String)"configRepository");
        this.configRepository = configRepository;
    }

    public void setMayReadArticleVersionHistoryPermission(@NotNull TenantId tenantId, @NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        this.configRepository.save((Object)new DbConfig(ConfigType.MAY_READ_ARTICLE_VERSION_HISTORY, tenantId.getId(), permissionType.toString()));
    }

    @NotNull
    public PermissionType getMayReadArticleVersionHistoryPermission(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ConfigType configType = ConfigType.MAY_READ_ARTICLE_VERSION_HISTORY;
        UUID uUID = tenantId.getId();
        Optional newPermission = this.configRepository.findById((Object)new ConfigId(uUID, configType));
        return newPermission.isPresent() ? PermissionType.valueOf((String)((DbConfig)newPermission.get()).getConfigValue()) : PermissionType.READER;
    }
}

