/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.assistant.util;

import de.justsoftware.wikiservice.ai.assistant.util.ThinkFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/wikiservice/ai/assistant/util/ThinkFilter;", "", "<init>", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "insideThink", "", "lastEmittedIndex", "", "filterAndExtractNewContent", "", "chunk", "Companion", "wiki-service"})
public final class ThinkFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder buffer = new StringBuilder();
    private boolean insideThink;
    private int lastEmittedIndex;
    @NotNull
    private static final String THINK_OPEN_TAG = "<think>";
    @NotNull
    private static final String THINK_CLOSING_TAG = "</think>";

    @NotNull
    public final String filterAndExtractNewContent(@NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.buffer.append(chunk);
        StringBuilder output = new StringBuilder();
        int i = this.lastEmittedIndex;
        while (i < this.buffer.length()) {
            if (!this.insideThink) {
                int startThink = this.buffer.indexOf(THINK_OPEN_TAG, i);
                if (startThink == -1) {
                    output.append(this.buffer.substring(i));
                    i = this.buffer.length();
                    break;
                }
                output.append(this.buffer.substring(i, startThink));
                i = startThink + 7;
                this.insideThink = true;
                continue;
            }
            int endThink = this.buffer.indexOf(THINK_CLOSING_TAG, i);
            if (endThink == -1) {
                i = this.buffer.length();
                break;
            }
            i = endThink + 8;
            this.insideThink = false;
        }
        this.lastEmittedIndex = i;
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

