/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.assistant.controller;

import de.justsoftware.wikiservice.ai.assistant.application.AiAssistantApplicationService;
import de.justsoftware.wikiservice.ai.assistant.application.model.AiTaskRequestDto;
import de.justsoftware.wikiservice.ai.assistant.business.AiAssistantService;
import de.justsoftware.wikiservice.ai.assistant.controller.AiAssistantController;
import de.justsoftware.wikiservice.authorization.AuthContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/ai"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/ai/assistant/controller/AiAssistantController;", "", "aiAssistantApplicationService", "Lde/justsoftware/wikiservice/ai/assistant/application/AiAssistantApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/ai/assistant/application/AiAssistantApplicationService;)V", "generateText", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "aiTaskRequest", "Lde/justsoftware/wikiservice/ai/assistant/application/model/AiTaskRequestDto;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "Companion", "wiki-service"})
public class AiAssistantController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AiAssistantApplicationService aiAssistantApplicationService;
    private static final Logger LOG = LoggerFactory.getLogger(AiAssistantController.class);

    public AiAssistantController(@NotNull AiAssistantApplicationService aiAssistantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)aiAssistantApplicationService, (String)"aiAssistantApplicationService");
        this.aiAssistantApplicationService = aiAssistantApplicationService;
    }

    @PostMapping(value={"/generateText"}, produces={"text/event-stream"})
    @NotNull
    public SseEmitter generateText(@RequestBody @NotNull AiTaskRequestDto aiTaskRequest, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)aiTaskRequest, (String)"aiTaskRequest");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        SseEmitter emitter = new SseEmitter(Long.valueOf(0L));
        Ref.ObjectRef handle = new Ref.ObjectRef();
        handle.element = this.aiAssistantApplicationService.generateText(aiTaskRequest.getInstruction(), aiTaskRequest.getText(), arg_0 -> AiAssistantController.generateText$lambda$0(emitter, handle, arg_0), () -> AiAssistantController.generateText$lambda$1(emitter), arg_0 -> AiAssistantController.generateText$lambda$2(emitter, arg_0), authContext);
        Function0 stop = () -> AiAssistantController.generateText$lambda$3(handle);
        emitter.onTimeout(() -> AiAssistantController.generateText$lambda$4(stop));
        emitter.onError(arg_0 -> AiAssistantController.generateText$lambda$5(stop, arg_0));
        return emitter;
    }

    private static final Unit generateText$lambda$0(SseEmitter $emitter, Ref.ObjectRef $handle, String token) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            try {
                $emitter.send(SseEmitter.event().data((Object)token));
            }
            catch (Exception e) {
                AiAssistantService.StreamHandle streamHandle;
                LOG.debug("Emitter send failed (client gone): " + e.getMessage());
                try {
                    $emitter.complete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((streamHandle = (AiAssistantService.StreamHandle)$handle.element) == null || (streamHandle = streamHandle.getCancel()) == null) break block4;
                streamHandle.invoke();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateText$lambda$1(SseEmitter $emitter) {
        try {
            $emitter.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateText$lambda$2(SseEmitter $emitter, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            $emitter.completeWithError(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateText$lambda$3(Ref.ObjectRef $handle) {
        ((AiAssistantService.StreamHandle)$handle.element).getCancel().invoke();
        LOG.info("SSE stopped (client disconnected/timeout/error)");
        return Unit.INSTANCE;
    }

    private static final void generateText$lambda$4(Function0 $stop) {
        $stop.invoke();
    }

    private static final void generateText$lambda$5(Function0 $stop, Throwable throwable) {
        $stop.invoke();
    }
}

