/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.monitoring.business.model.LdapConnectionError;
import de.justsoftware.onx.monitoring.business.model.LdapNotConfiguredException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@ParametersAreNonnullByDefault
public class LdapMonitoringService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapMonitoringService.class);
    private static final int CONNECTION_TIMEOUT_IN_MS = 2000;
    private final List<LDAPSearchContext> _ldapSearchContexts;

    public LdapMonitoringService(List<LDAPSearchContext> searchContexts) {
        this._ldapSearchContexts = searchContexts;
    }

    @Nonnull
    public ImmutableList<LdapConnectionError> checkLdapConnection() throws LdapNotConfiguredException {
        if (this._ldapSearchContexts.isEmpty()) {
            throw new LdapNotConfiguredException();
        }
        ImmutableList.Builder errors = ImmutableList.builder();
        this._ldapSearchContexts.forEach(ldapSearchContext -> {
            LdapTemplate ldapTemplate = ldapSearchContext.getLdapTemplate();
            LdapContextSource contextSource = (LdapContextSource)ldapTemplate.getContextSource();
            String baseDN = (String)ldapSearchContext.getBaseDNList().get(0);
            SearchControls searchControls = new SearchControls();
            searchControls.setTimeLimit(2000);
            searchControls.setSearchScope(2);
            searchControls.setCountLimit(1L);
            try {
                contextSource.getReadOnlyContext().search(baseDN, ldapSearchContext.getFilter(), searchControls);
            }
            catch (NamingException | org.springframework.ldap.NamingException e) {
                LdapConnectionError error = new LdapConnectionError(contextSource.getUrls(), e.getMessage());
                LOG.error("LDAP health check failed! For more details check debug log. {}", (Object)error);
                LOG.debug("LDAP health check failed!", e);
                errors.add((Object)error);
            }
        });
        return errors.build();
    }
}

