/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.monitoring.business.LdapMonitoringService;
import de.justsoftware.onx.monitoring.business.ToroHealthIndicator;
import de.justsoftware.onx.monitoring.business.model.LdapNotConfiguredException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.boot.actuate.health.Health;

@ParametersAreNonnullByDefault
public class LdapConnectionHealthIndicator
extends ToroHealthIndicator {
    private final LdapMonitoringService _ldapMonitoringService;

    public LdapConnectionHealthIndicator(LdapMonitoringService ldapMonitoringService) {
        this._ldapMonitoringService = ldapMonitoringService;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            ImmutableList errors = this._ldapMonitoringService.checkLdapConnection();
            if (errors.isEmpty()) {
                builder.up();
            } else {
                builder.down().withDetail("errors", (Object)errors);
            }
        }
        catch (LdapNotConfiguredException e) {
            builder.up().withDetail("message", (Object)"LDAP is not available on this host.");
        }
    }
}

