/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server.upload;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.server.upload.UploadResult;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithLocale;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractImageUploadServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImageUploadServlet.class);
    protected final StorageServerHelper _storageServerHelper;
    protected final I18nService _i18nService;
    private final Settings _settings;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final ImmutableSet<String> _acceptableContentTypes;
    private Collection<ImageSize> _activeImageSizes = StorageServerHelper.DEFAULT_IMAGE_SIZES;

    @ParametersAreNonnullByDefault
    protected AbstractImageUploadServlet(Settings settings, StorageServerHelper storageServerHelper, SessionAuthorizationContextProvider authorizationContextProvider, I18nService i18nService, Set<String> acceptableContentTypes) {
        this._settings = settings;
        this._storageServerHelper = storageServerHelper;
        this._authorizationContextProvider = authorizationContextProvider;
        this._i18nService = i18nService;
        this._acceptableContentTypes = ImmutableSet.copyOf(acceptableContentTypes);
    }

    protected abstract UploadResult returnError(HttpServletRequest var1, String var2);

    protected String getSizeUnacceptableError(AuthorizationContextWithLocale authCtx) {
        return ((BasicMessages)this._i18nService.createProxy(BasicMessages.class, authCtx.getLocale())).imageSizeUnacceptable(this._settings.getImageMaxFileSize().intValue());
    }

    protected String getDimensionUnacceptableError(AuthorizationContextWithLocale authCtx) {
        return ((BasicMessages)this._i18nService.createProxy(BasicMessages.class, authCtx.getLocale())).fileExceedsImageDimensionRestrictions(12000, 12000);
    }

    public ModelAndView handleRequest(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException {
        List items;
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser((HttpServletRequest)request, response);
        UploadResult result = this.handleUpload(request, authorizationContext, items = this.getFileItems(request));
        if (result != null) {
            response.setContentType(result.getContentType());
            response.getWriter().write(result.getContent());
        }
        return null;
    }

    @CheckForNull
    private UploadResult handleUpload(@Nonnull MultipartHttpServletRequest request, @Nonnull AuthorizationContext authorizationContext, @Nullable List<MultipartFile> files) throws IOException {
        if (files == null) {
            return null;
        }
        StringBuilder messages = new StringBuilder();
        request.getFileMap();
        for (MultipartFile file : files) {
            messages.append(this.checkFile(file, authorizationContext));
        }
        HashMap parameters = Maps.newHashMap();
        Enumeration names = request.getParameterNames();
        while (names != null && names.hasMoreElements()) {
            String parameterName = (String)names.nextElement();
            String[] values = request.getParameterValues(parameterName);
            if (values == null || values.length != 1) continue;
            parameters.put(parameterName, values[0]);
        }
        if (messages.length() > 0) {
            return this.returnError((HttpServletRequest)request, messages.toString());
        }
        if (files.size() <= 0) {
            return this.returnError((HttpServletRequest)request, "No images uploaded");
        }
        return this.saves(files, (AuthorizationCheckContextWithUserId)authorizationContext, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidDimension(MultipartFile fileItem) {
        try {
            InputStream inputStream = fileItem.getInputStream();
            ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
            ImageReader reader = null;
            try {
                reader = (ImageReader)Iterators.getNext(ImageIO.getImageReaders(iis), null);
                if (reader != null) {
                    reader.setInput(iis);
                    boolean exceedsDimensions = reader.getWidth(0) * reader.getHeight(0) > 144000000;
                    boolean bl2 = !exceedsDimensions;
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (iis != null) {
                    iis.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("image meta data could not be read." + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @CheckForNull
    protected List<MultipartFile> getFileItems(@Nonnull MultipartHttpServletRequest request) {
        return new ArrayList<MultipartFile>(request.getFileMap().values());
    }

    protected String checkFile(MultipartFile item, AuthorizationContext authCtx) {
        Object result = "";
        if (!this.isContentTypeAcceptable(item)) {
            result = this.getContentTypeUnacceptableError(item.getOriginalFilename(), (AuthorizationContextWithLocale)authCtx);
        }
        if (!this.isFileSizeAcceptable(item)) {
            if (!((String)result).isEmpty()) {
                result = (String)result + "\n";
            }
            result = (String)result + this.getSizeUnacceptableError((AuthorizationContextWithLocale)authCtx);
        }
        if (!this.isValidDimension(item)) {
            if (!((String)result).isEmpty()) {
                result = (String)result + "\n";
            }
            result = (String)result + this.getDimensionUnacceptableError((AuthorizationContextWithLocale)authCtx);
        }
        return result;
    }

    protected boolean isFileSizeAcceptable(MultipartFile file) {
        return file.getSize() <= this._settings.getImageMaxFileSize();
    }

    protected boolean isContentTypeAcceptable(MultipartFile item) {
        String type = item.getOriginalFilename().substring(item.getOriginalFilename().lastIndexOf(46) + 1).toLowerCase();
        return this._acceptableContentTypes.contains((Object)type);
    }

    protected SaveImageResult saveFileOnStorageServer(MultipartFile item, String basePath, String newFilename, boolean squareOfImages) {
        return this._storageServerHelper.saveFileOnStorageServer(item, basePath, newFilename, this._activeImageSizes, squareOfImages);
    }

    protected String deleteFileOnStorageServer(String basePath, String filename) {
        return this._storageServerHelper.deleteFileOnStorageServer(basePath, filename);
    }

    public ImmutableSet<String> getAcceptableContentTypes() {
        return this._acceptableContentTypes;
    }

    protected abstract UploadResult saves(@Nonnull List<MultipartFile> var1, @Nonnull AuthorizationCheckContextWithUserId var2, @Nonnull HashMap<String, String> var3);

    public void setActiveImageSizes(Collection<ImageSize> imageSizes) {
        this._activeImageSizes = imageSizes;
    }

    public String getContentTypeUnacceptableError(String fileName, AuthorizationContextWithLocale authCtx) {
        return ((BasicMessages)this._i18nService.createProxy(BasicMessages.class, authCtx.getLocale())).uploadErrorInvalidFiletype(fileName);
    }
}

