/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.web.design;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.admin.LessResourceReloadListener;
import de.justsoftware.onx.admin.LessResourceReloadSource;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.design.business.ThemeUpdateListener;
import de.justsoftware.onx.design.business.ThemeUpdateSource;
import de.justsoftware.onx.design.shared.model.StaticWebResource;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.design.shared.model.ThemeWebResource;
import de.justsoftware.onx.design.shared.model.WebResource;
import de.justsoftware.web.design.DummHttpServletResponse;
import de.justsoftware.web.design.DummyHttpServletRequest;
import de.justsoftware.web.design.ThemeCacheInitializer;
import de.justsoftware.web.design.WebResourceHandler;
import de.justsoftware.web.design.WroCacheHandlerImpl;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.gwtwidgets.server.spring.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.resource.ResourceType;

@Service
@ParametersAreNonnullByDefault
public class WroCacheHandlerImpl
implements ServerEventHandler,
WebResourceHandler,
ServletContextListener,
ThemeCacheInitializer,
ThemeUpdateListener,
LessResourceReloadListener {
    public static final CacheKey DEFAULT_THEME_KEY = new CacheKey("theme-0", ResourceType.CSS, true);
    private static final ImmutableSet<CacheKey> DEFAULT_THEME_DEPENDENT_KEYS = ImmutableSet.of((Object)DEFAULT_THEME_KEY);
    private static final Logger LOG = LoggerFactory.getLogger(WroCacheHandlerImpl.class);
    private final WroFilter _wroFilter;
    private final WroManagerFactory _wroManagerFactory;
    private final Properties _wroProperties;

    @Autowired
    public WroCacheHandlerImpl(FilterRegistrationBean<WroFilter> wroFilter, @Qualifier(value="wroProperties") FactoryBean<Properties> wroProperties, ThemeUpdateSource themeUpdateSource, LessResourceReloadSource lessResourceReloadSource) {
        this._wroFilter = (WroFilter)wroFilter.getFilter();
        this._wroManagerFactory = this._wroFilter.getWroManagerFactory();
        try {
            this._wroProperties = (Properties)wroProperties.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        themeUpdateSource.setUpdateListener((ThemeUpdateListener)this);
        lessResourceReloadSource.setReloadListener((LessResourceReloadListener)this);
    }

    public void initThemeCache() {
        this.runInWroContextIfPossible((WroContextHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clearCachedResources() {
        this.runInWroContextIfPossible(() -> {
            CacheStrategy cacheStrategy = ((WroManager)this._wroManagerFactory.create()).getCacheStrategy();
            cacheStrategy.clear();
        });
    }

    public void onThemeUpdated(ThemeId themeId, boolean isDefault) {
        this.runInWroContextIfPossible(() -> {
            ThemeWebResource changedThemeResource = ThemeWebResource.of((ThemeId)themeId);
            ((WroManager)this._wroManagerFactory.create()).getModelFactory().destroy();
            Optional.ofNullable(this.findCacheKey((WebResource)changedThemeResource)).ifPresent(cacheKey -> this.checkCacheKeys(ImmutableSet.of((Object)cacheKey)));
            if (isDefault) {
                this.checkCacheKeys(DEFAULT_THEME_DEPENDENT_KEYS);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<WebResource, String> getCurrentResourceNames(Iterable<WebResource> resources, HttpServletRequest request, HttpServletResponse response) {
        this.initWroContext(request, response);
        try {
            HashMap hashMap = this.extractResources(resources, request);
            return hashMap;
        }
        catch (WroRuntimeException e) {
            LOG.warn("error when loading web reource names " + e.getMessage());
            ((WroManager)this._wroManagerFactory.create()).getModelFactory().destroy();
            HashMap hashMap = this.extractResources(resources, request);
            return hashMap;
        }
        finally {
            Context.unset();
        }
    }

    @Nonnull
    private HashMap<WebResource, String> extractResources(Iterable<WebResource> resources, HttpServletRequest request) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        CacheStrategy cacheStrategy = ((WroManager)this._wroManagerFactory.create()).getCacheStrategy();
        for (WebResource resource : resources) {
            CacheKey key = this.findCacheKey(resource);
            CacheValue cachedValue = (CacheValue)cacheStrategy.get((Object)key);
            mapBuilder.put((Object)resource, (Object)this.formatResourceName(key, cachedValue, request));
        }
        return new HashMap<WebResource, String>((Map<WebResource, String>)mapBuilder.build());
    }

    @Nonnull
    private CacheKey findCacheKey(WebResource resource) {
        return new CacheKey(resource.getGroupName(), resource.getType() == WebResource.WebResourceType.CSS ? ResourceType.CSS : ResourceType.JS, resource.getType() == WebResource.WebResourceType.CSS);
    }

    @Nonnull
    private String formatResourceName(CacheKey key, CacheValue cachedValue, HttpServletRequest request) {
        return request.getContextPath() + "/assets/" + key.getGroupName() + "__" + cachedValue.getHash() + (key.getType() == ResourceType.CSS ? ".css" : ".js");
    }

    private void checkCacheKeys(ImmutableSet<CacheKey> cacheKeys) {
        this.runInWroContextIfPossible((WroContextHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initWroContext(HttpServletRequest request, HttpServletResponse response) {
        this.initWroContext(request, response, request.getServletContext(), this._wroFilter.getConfiguration());
    }

    private void initWroContext(HttpServletRequest request, HttpServletResponse response, ServletContext context, WroConfiguration config) {
        Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)new /* Unavailable Anonymous Inner Class!! */), (WroConfiguration)config);
    }

    private void runInWroContextIfPossible(WroContextHandler handler) {
        boolean contextSet = this.createWroContextIfPossible(ServletUtils.getRequest(), ServletUtils.getResponse());
        if (contextSet) {
            handler.runInWroContext();
            Context.unset();
        }
    }

    private boolean createWroContextIfPossible(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        if (Context.isContextSet()) {
            return true;
        }
        if (request != null && response != null) {
            this.initWroContext(request, response);
            return true;
        }
        return false;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        Runnable warmupRunnable = () -> this.warmUpCache((HttpServletRequest)new DummyHttpServletRequest(), (HttpServletResponse)new DummHttpServletResponse(), event.getServletContext());
        new Thread(warmupRunnable, "WroCacheInitializer").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warmUpCache(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        StopWatch stopWatch = new StopWatch("web resources warmup");
        try {
            LOG.info("start prewarming web resources cache");
            this.initWroContext(request, response, servletContext, new PropertyWroConfigurationFactory(this._wroProperties).create());
            CacheStrategy cacheStrategy = ((WroManager)this._wroManagerFactory.create()).getCacheStrategy();
            for (StaticWebResource resource : StaticWebResource.values()) {
                CacheKey key = this.findCacheKey((WebResource)resource);
                if (key == null) continue;
                stopWatch.start(resource.getGroupName());
                cacheStrategy.get((Object)key);
                stopWatch.stop();
            }
            Context.unset();
            LOG.info("done with cache warming");
        }
        catch (RuntimeException e) {
            LOG.error("exception during cache warm up", (Throwable)e);
        }
        finally {
            LOG.info(stopWatch.prettyPrint());
        }
    }
}

