/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.model;

import com.freiheit.toro.common.shared.util.UrlUtil;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum LoginPage {
    REQUEST_NEW_PASSWORD("/account/password/requestNewPassword"),
    SET_NEW_PASSWORD(params -> "/account/password/setNewPassword/" + (String)params.get("code")),
    SET_NEW_PASSWORD_ACCOUNT_BLOCKED("/account/password/blockedAccount"),
    SET_NEW_PASSWORD_ACCOUNT_INEXISTENT("/account/password/inexistantAccount"),
    SET_NEW_PASSWORD_EXPIRED("/account/password/expiredLink"),
    SET_NEW_PASSWORD_INVALID("/account/password/invalidLink"),
    NEW_MAIL("/account/mail/newMailVerified"),
    NEW_MAIL_FAILURE("/account/mail/newMailFailed"),
    REGISTRATION(params -> "/registration/" + (String)params.get("invitationHash")),
    REGISTRATION_INVALID_HASH("/registration/invalidHash"),
    REQUEST_ACCOUNT_ACTIVATION("/account/activation"),
    ACCOUNT_ACTIVATION_SUCCEED("/account/activationSuccess"),
    ACCOUNT_ACTIVATION_BLOCKED("/account/activationBlocked"),
    ACCOUNT_ACTIVATION_FAILURE("/account/activationFailure"),
    FOOTER_TERMS(UrlUtil.LOGIN_TERMS),
    FOOTER_PRIVACY(UrlUtil.LOGIN_PRIVACY),
    FOOTER_ABOUT(UrlUtil.LOGIN_ABOUT),
    FOOTER_HELP(UrlUtil.LOGIN_HELP),
    FOOTER_IMPRINT(UrlUtil.LOGIN_IMPRINT),
    FOOTER_PRESS(UrlUtil.LOGIN_PRESS),
    FOOTER_ARTICLES_OF_ASSOCIATION(UrlUtil.LOGIN_ARTICLES_OF_ASSOCIATION);

    private final Function<Map<String, String>, String> _urlCreator;

    private LoginPage(String newLoginUrl) {
        this(string, n, params -> newLoginUrl);
    }

    private LoginPage(Function<Map<String, String>, String> urlCreator) {
        this._urlCreator = urlCreator;
    }

    @Nonnull
    public String getUrl(Map<String, String> params) {
        return (String)this._urlCreator.apply(params);
    }

    @Nonnull
    public String getUrl() {
        return (String)this._urlCreator.apply(Map.of());
    }
}

