/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.authorization.presentation.server.ActivationController;
import de.justsoftware.onx.common.presentation.server.util.RedirectUtil;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.process.business.model.AccountActivationResult;
import de.justsoftware.onx.server.LoginPageVisibilityService;
import de.justsoftware.onx.server.model.LoginPage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@ParametersAreNonnullByDefault
public class ActivationController {
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final PersonService _personService;
    private final LoginPageVisibilityService _loginPageVisibilityService;
    private final Settings _settings;

    @Autowired
    public ActivationController(SessionAuthorizationContextProvider authorizationContextProvider, PersonService personService, LoginPageVisibilityService loginPageVisibilityService, Settings settings) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._personService = personService;
        this._loginPageVisibilityService = loginPageVisibilityService;
        this._settings = settings;
    }

    @RequestMapping(value={"/requestActivation"}, produces={"text/html"})
    public void requestActivationPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationCheckContext authCtx = this._authorizationContextProvider.getAuthorizationCheckContextForLoggedInOrNotLoggedInUser(request, response);
        if (!this._loginPageVisibilityService.isActivationPossible(authCtx)) {
            RedirectUtil.redirectToToken((HttpServletRequest)request, (HttpServletResponse)response, null);
            return;
        }
        response.sendRedirect(LoginPage.REQUEST_ACCOUNT_ACTIVATION.getUrl());
    }

    @RequestMapping(value={"/activateAccount/{activationToken}"}, produces={"text/html"})
    public void activateAccount(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="activationToken") String activationToken) throws IOException {
        AccountActivationResult result = this._settings.isActivationViaOptInEnabled() ? this._personService.activateAccount(activationToken) : AccountActivationResult.ERROR;
        response.sendRedirect(ActivationController.page((AccountActivationResult)result).getUrl());
    }

    @Nonnull
    private static LoginPage page(AccountActivationResult result) {
        switch (1.$SwitchMap$de$justsoftware$onx$process$business$model$AccountActivationResult[result.ordinal()]) {
            case 1: {
                return LoginPage.ACCOUNT_ACTIVATION_BLOCKED;
            }
            case 2: {
                return LoginPage.ACCOUNT_ACTIVATION_SUCCEED;
            }
        }
        return LoginPage.ACCOUNT_ACTIVATION_FAILURE;
    }
}

