/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.ClientAuthenticationToken;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.model.JustConnectUserAuthenticationToken;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@ParametersAreNonnullByDefault
@Service(value="jwtTokenAuthenticationProvider")
public class JwtTokenAuthenticationProvider
implements JustAuthenticationProvider {
    @Autowired
    private PersonReadWriteDataService _personReadWriteDataService;
    @Autowired
    private UserDetailsChecker _userDetailsChecker;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof JwtAuthenticationToken)) {
            return null;
        }
        JwtAuthenticationToken authenticationToken = (JwtAuthenticationToken)authentication;
        ProfileId id = this.getProfileId(authenticationToken);
        if (id != null) {
            DBPerson person = this._personReadWriteDataService.getPersonById(id.asPersonId());
            if (person == null) {
                throw new AuthenticationServiceException("Got token for profile " + String.valueOf(id) + ", but could not load corresponding person from db");
            }
            JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser((DBPerson)person);
            this._userDetailsChecker.check((UserDetails)justConnectUser);
            return new JustConnectUserAuthenticationToken(justConnectUser, authenticationToken.getExpirationTime(), authenticationToken.getCustomJwtClaims());
        }
        Optional optionalTenantId = TenantId.parse((String)((String)authenticationToken.getCustomJwtClaims().get((Object)"tenantId")));
        if (optionalTenantId.isPresent()) {
            String scope = (String)authenticationToken.getCustomJwtClaims().get((Object)"scope");
            Set authorities = StringUtils.commaDelimitedListToSet((String)scope).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
            return new ClientAuthenticationToken((TenantId)optionalTenantId.get(), authenticationToken.getPrincipal(), authorities);
        }
        return null;
    }

    @CheckForNull
    private final ProfileId getProfileId(JwtAuthenticationToken authentication) {
        String profileIdString = (String)authentication.getCustomJwtClaims().get((Object)"profileId");
        if (profileIdString != null) {
            return ProfileId.parse((String)profileIdString);
        }
        String principalString = authentication.getPrincipal();
        if (principalString != null && principalString.matches("PROFILE,\\d+")) {
            return ProfileId.parse((String)principalString);
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

