/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server;

import com.freiheit.toro.server.CachingUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CacheFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equalsIgnoreCase(httpRequest.getMethod())) {
            CachingUtil.setNoCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        } else {
            String requestURI = httpRequest.getRequestURI();
            if (requestURI.contains("nocache")) {
                CachingUtil.setNoCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            } else if (requestURI.contains(".cache.")) {
                CachingUtil.setCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (long)CachingUtil.CACHING_DURATION_ONE_YEAR);
            }
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

