--liquibase formatted sql

--changeset vinh.phu.phan:create_solr_document_visibility_table
CREATE TABLE solr_document_visibility (
    id VARCHAR(255) NOT NULL PRIMARY KEY,
    type VARCHAR(255) NOT NULL,
    visible_by_parent_id VARCHAR(255),
    visible_for_roles VARCHAR(4096),
    restricted_visible_for_roles VARCHAR(4096),
    use_restricted_visibility BOOLEAN,
    tenant_id UUID,
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
CREATE INDEX solr_document_visibility_type_index ON solr_document_visibility(type);
CREATE INDEX solr_document_visibility_visible_by_parent_id_index ON solr_document_visibility(visible_by_parent_id);

--changeset vinh.phu.phan:update_visible_for_roles_and_restricted_visible_for_roles_to_text
ALTER TABLE solr_document_visibility ALTER COLUMN visible_for_roles TYPE text;
ALTER TABLE solr_document_visibility ALTER COLUMN restricted_visible_for_roles TYPE text;

