/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.config;

import de.justsoftware.search.config.ExceptionHandlerConfiguration;
import de.justsoftware.search.exception.UnauthorizedException;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/search/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleUnauthorizedException", "Lde/justsoftware/search/exception/UnauthorizedException;", "handleBadRequestExceptions", "forwardRestOperationsExceptions", "", "Lorg/springframework/web/client/HttpStatusCodeException;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/search/config/ExceptionHandlerConfiguration\n+ 2 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,60:1\n8#2:61\n7#2,3:62\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/search/config/ExceptionHandlerConfiguration\n*L\n56#1:61\n56#1:62,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOG.error("Internal Server Error:", (Throwable)e);
        return DEFAULT_ERROR;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @Nullable
    public String handleBadRequestExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={HttpClientErrorException.class, HttpServerErrorException.class})
    @ResponseBody
    @NotNull
    public byte[] forwardRestOperationsExceptions(@NotNull HttpStatusCodeException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setStatus(e.getStatusCode().value());
        byte[] byArray = e.getResponseBodyAsByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getResponseBodyAsByteArray(...)");
        return byArray;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

