/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.search.business.SolrIndexService;
import de.justsoftware.search.business.SolrIndexService$reindexAll$;
import de.justsoftware.search.business.SolrIndexService$updateChildrenVisibilities$lambda$15$;
import de.justsoftware.search.business.model.SolrVisibilitySearchResult;
import de.justsoftware.search.persistence.SolrDocumentVisibilityRepository;
import de.justsoftware.search.persistence.model.DbSolrDocumentVisibility;
import de.justsoftware.search.persistence.model.SolrDocumentVisibility;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.JustSocialSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.util.CollectionUtilsKt;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u0000 82\u00020\u0001:\u000278B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J\u001c\u0010\u0017\u001a\u00020\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0012JD\u0010\u0017\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\f\b\u0002\u0010\"\u001a\u00060\u001cj\u0002`\u001dH\u0012J\u0016\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0017J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0017J\b\u0010(\u001a\u00020\u0013H\u0016J\u001a\u0010)\u001a\u00020\u0013*\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0015H\u0012J\u001a\u0010,\u001a\u00020\u0013*\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0015H\u0012J\u001a\u0010#\u001a\u00020\u0013*\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020-0\u0015H\u0012J\u001a\u0010.\u001a\u00020\u0013*\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020-0\u0015H\u0012J\u001a\u0010/\u001a\u00020\u0013*\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020-0\u0015H\u0012J8\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019*\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0012J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a05H\u0012J\"\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020-05H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00069"}, d2={"Lde/justsoftware/search/business/SolrIndexService;", "", "justSocialCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "solrDocumentVisibilityRepository", "Lde/justsoftware/search/persistence/SolrDocumentVisibilityRepository;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/shared/SolrIndexQueue;Lde/justsoftware/search/persistence/SolrDocumentVisibilityRepository;Lio/micrometer/core/instrument/MeterRegistry;)V", "justSocialSolrCore", "Lde/justsoftware/search/business/SolrIndexService$SolrCore;", "getJustSocialSolrCore$search_service$annotations", "()V", "getJustSocialSolrCore$search_service", "()Lde/justsoftware/search/business/SolrIndexService$SolrCore;", "indexSolrDocuments", "", "docs", "", "Lde/justsoftware/search/shared/model/JustSocialSolrDocument;", "updateChildrenVisibilities", "changedVisibilities", "", "Lde/justsoftware/search/shared/model/SearchableId;", "Lde/justsoftware/search/business/model/SolrVisibilitySearchResult;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "updateGrandChildren", "", "depth", "", "logSummaryBuilder", "deleteSolrDocuments", "ids", "reindex", "type", "Lde/justsoftware/search/shared/model/SearchType;", "reindexAll", "addSolrDocuments", "documents", "Lorg/apache/solr/common/SolrInputDocument;", "addSolrDocumentsIndividually", "", "deleteSolrDocumentsByParentIds", "deleteSolrDocumentsIndividually", "filterChangedVisibility", "currentSolrVisibilities", "getChildrenVisibility", "Ljava/util/stream/Stream;", "parentIds", "", "loadSolrVisibilities", "SolrCore", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSolrIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/search/business/SolrIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/search/util/CollectionUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,515:1\n1872#2,3:516\n1557#2:519\n1628#2,3:520\n1628#2,3:524\n1619#2:528\n1863#2:529\n1864#2:531\n1620#2:532\n1557#2:533\n1628#2,3:534\n1202#2,2:537\n1230#2,4:539\n1557#2:543\n1628#2,3:544\n1544#2:553\n1557#2:568\n1628#2,3:569\n1053#2:572\n1557#2:573\n1628#2,3:574\n1872#2,2:577\n1557#2:579\n1628#2,3:580\n1874#2:583\n1863#2,2:584\n1872#2,3:586\n1863#2,2:589\n1628#2,3:599\n1557#2:602\n1628#2,3:603\n1202#2,2:606\n1230#2,4:608\n1611#2,9:612\n1863#2:621\n1864#2:623\n1620#2:624\n1544#2:625\n1485#2:626\n1510#2,3:627\n1513#2,3:637\n1557#2:643\n1628#2,3:644\n1863#2,2:648\n1202#2,2:650\n1230#2,4:652\n7#3:523\n10#3:527\n7#3:598\n1#4:530\n1#4:622\n17#5,6:547\n535#6:554\n520#6,6:555\n535#6:561\n520#6,6:562\n535#6:591\n520#6,6:592\n381#6,7:630\n126#7:640\n153#7,2:641\n155#7:647\n8#8:656\n7#8,3:657\n*S KotlinDebug\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/search/business/SolrIndexService\n*L\n81#1:516,3\n93#1:519\n93#1:520,3\n96#1:524,3\n97#1:528\n97#1:529\n97#1:531\n97#1:532\n101#1:533\n101#1:534,3\n102#1:537,2\n102#1:539,4\n104#1:543\n104#1:544,3\n171#1:553\n190#1:568\n190#1:569,3\n213#1:572\n222#1:573\n222#1:574,3\n225#1:577,2\n230#1:579\n230#1:580,3\n225#1:583\n245#1:584,2\n265#1:586,3\n302#1:589,2\n320#1:599,3\n327#1:602\n327#1:603,3\n328#1:606,2\n328#1:608,4\n140#1:612,9\n140#1:621\n140#1:623\n140#1:624\n151#1:625\n156#1:626\n156#1:627,3\n156#1:637,3\n157#1:643\n157#1:644,3\n158#1:648,2\n162#1:650,2\n162#1:652,4\n96#1:523\n97#1:527\n320#1:598\n97#1:530\n140#1:622\n116#1:547,6\n176#1:554\n176#1:555,6\n177#1:561\n177#1:562,6\n316#1:591\n316#1:592,6\n156#1:630,7\n157#1:640\n157#1:641,2\n157#1:647\n331#1:656\n331#1:657,3\n*E\n"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient justSocialCoreLeaderSolrClient;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    private final SolrDocumentVisibilityRepository solrDocumentVisibilityRepository;
    @NotNull
    private final SolrCore justSocialSolrCore;
    @NotNull
    private static final Logger LOG;
    private static final Logger INDEX_LOG;

    public SolrIndexService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient justSocialCoreLeaderSolrClient, @NotNull SolrIndexQueue solrIndexQueue, @NotNull SolrDocumentVisibilityRepository solrDocumentVisibilityRepository, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)justSocialCoreLeaderSolrClient, (String)"justSocialCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)solrDocumentVisibilityRepository, (String)"solrDocumentVisibilityRepository");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.justSocialCoreLeaderSolrClient = justSocialCoreLeaderSolrClient;
        this.solrIndexQueue = solrIndexQueue;
        this.solrDocumentVisibilityRepository = solrDocumentVisibilityRepository;
        this.justSocialSolrCore = new SolrCore("justsocial", this.justSocialCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getJustSocialSolrCore$search_service() {
        return this.justSocialSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getJustSocialSolrCore$search_service$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void indexSolrDocuments(@NotNull List<? extends JustSocialSolrDocument> docs) {
        void $this$mapTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$mapTo$iv$iv3;
        Iterable $this$mapToSet$iv;
        Collection collection;
        Collection destination$iv$iv;
        Object object;
        Iterable $this$forEachIndexed$iv;
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        if (docs.isEmpty()) {
            return;
        }
        if (INDEX_LOG.isDebugEnabled()) {
            $this$forEachIndexed$iv = CollectionsKt.chunked((Iterable)docs, (int)100);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void chunk;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int index = n;
                boolean bl = false;
                Object[] objectArray = new Object[]{index, docs.size(), CollectionsKt.joinToString$default((Iterable)((Iterable)chunk), (CharSequence)",", null, null, (int)0, null, SolrIndexService::indexSolrDocuments$lambda$1$lambda$0, (int)30, null)};
                INDEX_LOG.debug("INDEX DOCS RETRIEVE (Log-chunk {} of {} total elements): {}", objectArray);
            }
        }
        LOG.info("Updating indexed documents: " + docs.size());
        if (LOG.isDebugEnabled()) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv2;
            $this$forEachIndexed$iv = docs;
            object = LOG;
            boolean $i$f$map = false;
            void index$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv : $this$mapTo$iv$iv4) {
                void it;
                JustSocialSolrDocument index = (JustSocialSolrDocument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            object.debug("Updating index for " + (List)destination$iv$iv);
        }
        Iterable $i$f$map = docs;
        object = this;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            JustSocialSolrDocument bl = (JustSocialSolrDocument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getId().toCanonicalId());
        }
        $this$mapToSet$iv = docs;
        collection = (Set)destination$iv$iv2;
        boolean $i$f$mapNotNullToSet22 = false;
        $this$mapTo$iv$iv3 = $this$mapNotNullToSet$iv;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            JustSocialSolrDocument it2 = (JustSocialSolrDocument)element$iv$iv;
            boolean bl3 = false;
            SearchableId searchableId = Companion.getVisibleByParentId(it2);
            if ((searchableId != null ? searchableId.toCanonicalId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set set = (Set)destination$iv$iv2;
        Map solrVisibilities = super.loadSolrVisibilities(SetsKt.plus((Set)collection, (Iterable)set));
        Iterable $i$f$mapNotNullToSet22 = docs;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            JustSocialSolrDocument element$iv$iv$iv = (JustSocialSolrDocument)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add(Companion.access$calculateSolrVisibility((Companion)Companion, (JustSocialSolrDocument)it3, (Map)solrVisibilities));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it4;
            SolrVisibilitySearchResult bl = (SolrVisibilitySearchResult)element$iv$iv;
            object = destination$iv$iv4;
            boolean bl5 = false;
            object.put(it4.getId(), element$iv$iv);
        }
        Map calculatedVisibilities = destination$iv$iv4;
        Map changedVisibilities = this.filterChangedVisibility(calculatedVisibilities, solrVisibilities);
        Iterable $this$map$iv3 = docs;
        boolean $i$f$map3 = false;
        destination$iv$iv4 = $this$map$iv3;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            JustSocialSolrDocument bl5 = (JustSocialSolrDocument)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(Companion.access$toSolrDocument((Companion)Companion, (JustSocialSolrDocument)it5, (Map)calculatedVisibilities));
        }
        List solrDocs = (List)destination$iv$iv5;
        this.addSolrDocuments(this.getJustSocialSolrCore$search_service(), solrDocs);
        this.solrDocumentVisibilityRepository.saveAllAndFlush((Iterable)Companion.access$toDbSolrDocumentVisibilities((Companion)Companion, calculatedVisibilities.values()));
        LOG.debug(solrDocs.size() + " solr docs updated to solr successfully.");
        this.updateChildrenVisibilities(changedVisibilities);
    }

    private void updateChildrenVisibilities(Map<SearchableId, SolrVisibilitySearchResult> changedVisibilities) {
        if (changedVisibilities.isEmpty()) {
            return;
        }
        StringBuilder logSummaryBuilder = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        logSummaryBuilder = SolrIndexService.updateChildrenVisibilities$default((SolrIndexService)this, changedVisibilities, (boolean)true, (int)0, null, (int)12, null);
        long updateTimeInMillis = System.currentTimeMillis() - start$iv;
        if (logSummaryBuilder != null) {
            LOG.info("Visibilities of children updated (" + updateTimeInMillis + " ms):\n" + logSummaryBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder updateChildrenVisibilities(Map<SearchableId, SolrVisibilitySearchResult> changedVisibilities, boolean updateGrandChildren, int depth, StringBuilder logSummaryBuilder) {
        if (changedVisibilities.isEmpty()) {
            return null;
        }
        Ref.IntRef childrenUpdatedCount = new Ref.IntRef();
        Stream childrenVisibilities = this.getChildrenVisibility(changedVisibilities.keySet());
        StringBuilder childLogSummary = new StringBuilder();
        CollectionUtilsKt.chunked((Stream)childrenVisibilities, (int)1000).forEach(arg_0 -> SolrIndexService.updateChildrenVisibilities$lambda$16(arg_0 -> SolrIndexService.updateChildrenVisibilities$lambda$15(this, childrenUpdatedCount, childLogSummary, updateGrandChildren, depth, changedVisibilities, arg_0), arg_0));
        Iterable $this$groupingBy$iv = changedVisibilities.keySet();
        boolean $i$f$groupingBy = false;
        SolrIndexService.updateChildrenVisibilities$logLine((StringBuilder)logSummaryBuilder, (int)depth, (String)(changedVisibilities.size() + " parent visibilities " + GroupingKt.eachCount((Grouping)((Grouping)new /* Unavailable Anonymous Inner Class!! */)) + " changes cause updating visibilities of " + childrenUpdatedCount.element + " children."));
        if (LOG.isTraceEnabled()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Map<SearchableId, SolrVisibilitySearchResult> $this$filter$iv = changedVisibilities;
            boolean $i$f$filter = false;
            Map<SearchableId, SolrVisibilitySearchResult> map = $this$filter$iv;
            Map<SearchableId, SolrVisibilitySearchResult> destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                SolrVisibilitySearchResult value = (SolrVisibilitySearchResult)entry.getValue();
                if (!(value.getVisibleByParentId() == null)) continue;
                destination$iv$iv.put((SearchableId)element$iv$iv.getKey(), (SolrVisibilitySearchResult)element$iv$iv.getValue());
            }
            Map<SearchableId, SolrVisibilitySearchResult> rootParents = destination$iv$iv;
            Map<SearchableId, SolrVisibilitySearchResult> $this$filter$iv2 = changedVisibilities;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                SolrVisibilitySearchResult value = (SolrVisibilitySearchResult)entry.getValue();
                if (!(value.getVisibleByParentId() != null)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map parents = destination$iv$iv2;
            SolrIndexService.updateChildrenVisibilities$logLine((StringBuilder)logSummaryBuilder, (int)depth, (String)("Root Parent ids: " + rootParents.keySet()));
            SolrIndexService.updateChildrenVisibilities$logLine((StringBuilder)logSummaryBuilder, (int)depth, (String)("Parents ids: " + parents.keySet()));
        }
        if (childrenUpdatedCount.element > 0) {
            logSummaryBuilder.append((CharSequence)childLogSummary);
        }
        return logSummaryBuilder;
    }

    static /* synthetic */ StringBuilder updateChildrenVisibilities$default(SolrIndexService solrIndexService, Map map, boolean bl, int n, StringBuilder stringBuilder, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateChildrenVisibilities");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            stringBuilder = new StringBuilder();
        }
        return solrIndexService.updateChildrenVisibilities(map, bl, n, stringBuilder);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteSolrDocuments(@NotNull List<SearchableId> ids) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SearchableId searchableId = (SearchableId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$deleteSolrDocuments$stub_for_inlining$20 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List canonicalIds = (List)destination$iv$iv;
        this.deleteSolrDocuments(this.getJustSocialSolrCore$search_service(), canonicalIds);
        this.deleteSolrDocumentsByParentIds(this.getJustSocialSolrCore$search_service(), canonicalIds);
        this.solrDocumentVisibilityRepository.deleteAllById((Iterable)canonicalIds);
        this.solrDocumentVisibilityRepository.deleteAllByVisibleByParentIdIn(CollectionsKt.toSet((Iterable)canonicalIds));
    }

    @Transactional
    public void reindex(@NotNull SearchType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LOG.info("Reindex for " + type + " triggered");
        INDEX_LOG.debug("Reindex for {} triggered", (Object)type);
        this.solrDocumentVisibilityRepository.deleteAllByType(type);
        this.justSocialCoreLeaderSolrClient.deleteByQuery("type:" + type);
        this.justSocialCoreLeaderSolrClient.commit();
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (List)CollectionsKt.listOf((Object)type), null, (int)2, null);
    }

    public void reindexAll() {
        LOG.info("Reindex all triggered");
        INDEX_LOG.debug("Reindex all triggered");
        this.solrDocumentVisibilityRepository.deleteAllInBatch();
        this.justSocialCoreLeaderSolrClient.deleteByQuery("*:*");
        this.justSocialCoreLeaderSolrClient.commit();
        Iterable $this$sortedBy$iv = (Iterable)SearchType.getEntries();
        boolean $i$f$sortedBy = false;
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new reindexAll$$inlined$sortedBy$1())), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents) {
        if (documents.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents.size());
            if (LOG.isDebugEnabled()) {
                Collection<SolrInputField> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = documents;
                String string = "Successfully added documents with ids: {}";
                Logger logger = LOG;
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SolrInputDocument solrInputDocument = (SolrInputDocument)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((SolrInputField)it.get((Object)"id"));
                }
                collection = (List)destination$iv$iv;
                logger.debug(string, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            if (INDEX_LOG.isDebugEnabled()) {
                Iterable $this$forEachIndexed$iv = CollectionsKt.chunked((Iterable)documents, (int)100);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    Collection<SolrInputField> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void chunk;
                    int n;
                    Object item$iv$iv;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    item$iv$iv = (List)item$iv;
                    int index = n;
                    boolean bl = false;
                    Object[] objectArray = new Object[3];
                    objectArray[0] = index;
                    objectArray[1] = documents.size();
                    Iterable iterable = (Iterable)chunk;
                    int n2 = 2;
                    Object[] objectArray2 = objectArray;
                    String string = "ADDED TO SOLR (Log-chunk {} of {} total elements): {}";
                    Logger logger = INDEX_LOG;
                    boolean $i$f$map = false;
                    void var19_27 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it;
                        SolrInputDocument solrInputDocument = (SolrInputDocument)item$iv$iv2;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add((SolrInputField)it.get((Object)"id"));
                    }
                    collection = (List)destination$iv$iv;
                    objectArray2[n2] = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    logger.debug(string, objectArray);
                }
            }
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents) {
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Successfully added document with id: " + document.get((Object)"id"));
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
            if (INDEX_LOG.isDebugEnabled()) {
                Iterable $this$forEachIndexed$iv = CollectionsKt.chunked((Iterable)ids, (int)100);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void chunk;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    List list = (List)item$iv;
                    int index = n;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{index, ids.size(), CollectionsKt.joinToString$default((Iterable)((Iterable)chunk), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
                    INDEX_LOG.debug("DELETED FROM SOLR (Log-chunk {} of {} total elements): {}", objectArray);
                }
            }
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    private void deleteSolrDocumentsByParentIds(SolrCore $this$deleteSolrDocumentsByParentIds, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocumentsByParentIds.getClient().deleteByQuery("{!edismax q.op=AND qf='parent_id visible_by_parent_id' mm=1}" + ClientUtils.escapeQueryChars((String)CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.error("Batch deletion of children documents for solr core " + $this$deleteSolrDocumentsByParentIds.getCoreName() + " failed. Skip deletion of children.", (Throwable)e);
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<SearchableId, SolrVisibilitySearchResult> filterChangedVisibility(Map<SearchableId, SolrVisibilitySearchResult> $this$filterChangedVisibility, Map<SearchableId, SolrVisibilitySearchResult> currentSolrVisibilities) {
        void $this$filterTo$iv$iv;
        Map<SearchableId, SolrVisibilitySearchResult> $this$filter$iv = $this$filterChangedVisibility;
        boolean $i$f$filter = false;
        Map<SearchableId, SolrVisibilitySearchResult> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            SearchableId key = (SearchableId)entry.getKey();
            SolrVisibilitySearchResult value = (SolrVisibilitySearchResult)entry.getValue();
            if (!(!Intrinsics.areEqual((Object)currentSolrVisibilities.get(key), (Object)value))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Stream<SolrVisibilitySearchResult> getChildrenVisibility(Set<SearchableId> parentIds) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = parentIds;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SearchableId searchableId = (SearchableId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$getChildrenVisibility$stub_for_inlining$29 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Set ids = (Set)destination$iv$iv;
        Stream<SolrVisibilitySearchResult> stream = this.solrDocumentVisibilityRepository.streamAllByVisibleByParentIdIn(ids).map(arg_0 -> SolrIndexService.getChildrenVisibility$lambda$31(SolrIndexService::getChildrenVisibility$lambda$30, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    private Map<SearchableId, SolrVisibilitySearchResult> loadSolrVisibilities(Set<String> ids) {
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        List list = this.solrDocumentVisibilityRepository.findAllById((Iterable)ids);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbSolrDocumentVisibility dbSolrDocumentVisibility = (DbSolrDocumentVisibility)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object.add(DbSolrDocumentVisibility.Companion.toSolrVisibilitySearchResult((DbSolrDocumentVisibility)it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SolrVisibilitySearchResult bl = (SolrVisibilitySearchResult)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    private static final CharSequence indexSolrDocuments$lambda$1$lambda$0(JustSocialSolrDocument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIndexType() + ":" + it.getId() + "}";
    }

    private static final void updateChildrenVisibilities$logLine(StringBuilder $this$updateChildrenVisibilities_u24logLine, int $depth, String message) {
        $this$updateChildrenVisibilities_u24logLine.append(StringsKt.repeat((CharSequence)"  ", (int)$depth));
        $this$updateChildrenVisibilities_u24logLine.append(message);
        $this$updateChildrenVisibilities_u24logLine.append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateChildrenVisibilities$lambda$15(SolrIndexService this$0, Ref.IntRef $childrenUpdatedCount, StringBuilder $childLogSummary, boolean $updateGrandChildren, int $depth, Map $changedVisibilities, List chunk) {
        Object object;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNull((Object)chunk);
        Iterable $this$mapNotNull$iv = chunk;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SolrVisibilitySearchResult it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SolrVisibilitySearchResult child = (SolrVisibilitySearchResult)element$iv$iv;
            boolean bl2 = false;
            SolrVisibilitySearchResult calculatedVisibility = Companion.access$calculateSolrVisibility((Companion)Companion, (SolrVisibilitySearchResult)child, (Map)$changedVisibilities);
            if ((!Intrinsics.areEqual((Object)child, (Object)calculatedVisibility) ? calculatedVisibility : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List childrenChangedVisibilities = (List)destination$iv$iv;
        List solrDocs = Companion.access$toSolrDocuments((Companion)Companion, (List)childrenChangedVisibilities);
        this$0.addSolrDocuments(this$0.getJustSocialSolrCore$search_service(), solrDocs);
        this$0.solrDocumentVisibilityRepository.saveAllAndFlush((Iterable)Companion.access$toDbSolrDocumentVisibilities((Companion)Companion, (Collection)childrenChangedVisibilities));
        $childrenUpdatedCount.element += solrDocs.size();
        if (LOG.isDebugEnabled()) {
            Iterable $this$groupingBy$iv = childrenChangedVisibilities;
            boolean $i$f$groupingBy = false;
            SolrIndexService.updateChildrenVisibilities$logLine((StringBuilder)$childLogSummary, (int)$depth, (String)("* Batch of " + childrenChangedVisibilities.size() + " children visibilities " + GroupingKt.eachCount((Grouping)((Grouping)new updateChildrenVisibilities$lambda$15$$inlined$groupingBy$1($this$groupingBy$iv))) + " updated."));
        }
        if (LOG.isTraceEnabled()) {
            void $this$forEach$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object list$iv$iv;
            Object value$iv$iv$iv;
            SolrVisibilitySearchResult it;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = childrenChangedVisibilities;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object2;
                it = (SolrVisibilitySearchResult)t;
                boolean bl = false;
                SearchableId key$iv$iv = it.getVisibleByParentId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                list$iv$iv = entry;
                object = destination$iv$iv3;
                boolean bl = false;
                Iterable key$iv$iv = (Iterable)it.getValue();
                Object k = it.getKey();
                boolean $i$f$map2 = false;
                value$iv$iv$iv = $this$map$iv2;
                Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void v;
                    SolrVisibilitySearchResult solrVisibilitySearchResult = (SolrVisibilitySearchResult)item$iv$iv2;
                    Collection collection = destination$iv$iv32;
                    boolean bl5 = false;
                    collection.add(v.getId());
                }
                object.add(k + " --> " + (List)destination$iv$iv32);
            }
            $this$map$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                boolean bl2 = false;
                SolrIndexService.updateChildrenVisibilities$logLine((StringBuilder)$childLogSummary, (int)$depth, (String)p0);
            }
        }
        if ($updateGrandChildren) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable $this$forEach$iv = childrenChangedVisibilities;
            object = this$0;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void element$iv = $this$associateBy$iv;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                SolrVisibilitySearchResult bl = (SolrVisibilitySearchResult)element$iv$iv;
                Map map = destination$iv$iv4;
                boolean bl6 = false;
                map.put(it.getId(), element$iv$iv);
            }
            object.updateChildrenVisibilities(destination$iv$iv4, false, $depth + 1, $childLogSummary);
        }
        return Unit.INSTANCE;
    }

    private static final void updateChildrenVisibilities$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final SolrVisibilitySearchResult getChildrenVisibility$lambda$30(SolrDocumentVisibility it) {
        Intrinsics.checkNotNull((Object)it);
        return SolrDocumentVisibility.Companion.toSolrVisibilitySearchResult(it);
    }

    private static final SolrVisibilitySearchResult getChildrenVisibility$lambda$31(Function1 $tmp0, Object p0) {
        return (SolrVisibilitySearchResult)$tmp0.invoke(p0);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        INDEX_LOG = LoggerFactory.getLogger((String)"de.justsoftware.search.index.log");
    }
}

