/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.business.PermissionService;
import de.justsoftware.search.business.SearchService;
import de.justsoftware.search.business.model.DriveFileTypeResultCount;
import de.justsoftware.search.business.model.Filter;
import de.justsoftware.search.business.model.SearchResult;
import de.justsoftware.search.business.model.SearchResultParentDto;
import de.justsoftware.search.business.model.SearchTypeResultCount;
import de.justsoftware.search.business.model.SolrSearchResultDto;
import de.justsoftware.search.model.JustSocialSolrCoreSearchFields;
import de.justsoftware.search.shared.model.GlobalAdditionalFields;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchDriveFileType;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResponse;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J+\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0019\b\u0002\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\b H\u0012J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/search/business/SearchService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionService", "Lde/justsoftware/search/business/PermissionService;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/business/PermissionService;)V", "search", "Lde/justsoftware/search/business/model/SearchResult;", "authContext", "Lde/justsoftware/search/authorization/AuthorizationContext;", "query", "", "offset", "", "count", "filters", "Lde/justsoftware/search/business/model/Filter;", "sortBy", "Lde/justsoftware/search/shared/model/SortBy;", "sortDirection", "Lde/justsoftware/search/shared/model/SortDirection;", "Lde/justsoftware/search/shared/model/SearchResponse;", "searchParam", "Lde/justsoftware/search/shared/model/SearchParam;", "buildSolrQuery", "Lorg/apache/solr/client/solrj/SolrQuery;", "params", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/search/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,324:1\n10#2:325\n1619#3:326\n1863#3:327\n1864#3:329\n1620#3:330\n1557#3:331\n1628#3,3:332\n1557#3:335\n1628#3,3:336\n1557#3:339\n1628#3,3:340\n1#4:328\n8#5:343\n7#5,3:344\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n*L\n89#1:325\n89#1:326\n89#1:327\n89#1:329\n89#1:330\n96#1:331\n96#1:332,3\n102#1:335\n102#1:336,3\n109#1:339\n109#1:340,3\n89#1:328\n181#1:343\n181#1:344,3\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SEARCH_TYPE_FILTER_TAG = "search_type_filter";
    @NotNull
    private static final String FILE_TYPE_FILTER_TAG = "file_type_filter";
    @NotNull
    private static final String FILE_TYPE_FILTER_FIELD;
    @NotNull
    private static final String REQUESTED_FIELDS;
    @NotNull
    private static final String REQUESTED_FIELDS_FOR_PARENT_INFO;

    public SearchService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient solrClient, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.solrClient = solrClient;
        this.permissionService = permissionService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SearchResult search(@NotNull AuthorizationContext authContext, @NotNull String query, int offset, int count, @Nullable Filter filters, @NotNull SortBy sortBy, @NotNull SortDirection sortDirection) {
        List list;
        Collection<SolrSearchResultDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        void $this$map$iv2;
        Object v6;
        Iterable $i$f$map2;
        List searchTypeResultCounts;
        Object object;
        Object destination$iv$iv3;
        List $this$map$iv3;
        Map parentInfo;
        Iterable destination$iv$iv2;
        SearchResponse searchResponse;
        QueryResponse searchQueryResponse;
        block13: {
            List list3;
            Object v2;
            Iterable $i$f$mapNotNullTo22;
            de.justsoftware.search.shared.model.SearchResult it;
            FacetField $this$mapNotNullTo$iv$iv;
            block12: {
                Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
                Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
                searchQueryResponse = this.send(this.buildSolrQuery(new SearchParam(authContext.getTenantId(), authContext.getProfileId(), query, null, null, null, null, null, null, null, null, null, null, null, null, null, false, offset, count, sortBy, sortDirection, 131064, null), arg_0 -> SearchService.search$lambda$0(filters, arg_0)));
                searchResponse = Companion.access$toSearchResponse((Companion)Companion, (QueryResponse)searchQueryResponse);
                Iterable $this$mapNotNullToSet$iv = searchResponse.getResults();
                boolean $i$f$mapNotNullToSet = false;
                Iterable iterable = $this$mapNotNullToSet$iv;
                destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
                boolean $i$f$mapNotNullTo22 = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv = iterator.next();
                    Object element$iv$iv = element$iv$iv$iv;
                    boolean bl = false;
                    it = (de.justsoftware.search.shared.model.SearchResult)element$iv$iv;
                    boolean bl2 = false;
                    SearchableId searchableId = it.getParentId();
                    if ((searchableId != null ? searchableId.toCanonicalId() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set parentIds = (Set)destination$iv$iv2;
                parentInfo = Companion.access$getParentInfo((Companion)Companion, (SolrClient)this.solrClient, (Set)parentIds);
                List list4 = searchQueryResponse.getFacetFields();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFacetFields(...)");
                $i$f$mapNotNullTo22 = list4;
                for (Object $i$f$forEach2 : $i$f$mapNotNullTo22) {
                    FacetField it2 = (FacetField)$i$f$forEach2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"type")) continue;
                    v2 = $i$f$forEach2;
                    break block12;
                }
                v2 = null;
            }
            $this$mapNotNullTo$iv$iv = v2;
            if ($this$mapNotNullTo$iv$iv != null && (destination$iv$iv2 = $this$mapNotNullTo$iv$iv.getValues()) != null) {
                void $this$mapTo$iv$iv2;
                $i$f$mapNotNullTo22 = destination$iv$iv2;
                boolean $i$f$map2 = false;
                void $i$f$forEach2 = $this$map$iv3;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (FacetField.Count)item$iv$iv2;
                    object = destination$iv$iv3;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add((SearchTypeResultCount)new SearchTypeResultCount(SearchType.valueOf((String)string), (Number)it.getCount()));
                }
                list3 = (List)destination$iv$iv3;
            } else {
                list3 = null;
            }
            searchTypeResultCounts = list3;
            List list5 = searchQueryResponse.getFacetFields();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getFacetFields(...)");
            $i$f$map2 = list5;
            for (Object destination$iv$iv3 : $i$f$map2) {
                FacetField it3 = (FacetField)destination$iv$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)FILE_TYPE_FILTER_FIELD)) continue;
                v6 = destination$iv$iv3;
                break block13;
            }
            v6 = null;
        }
        destination$iv$iv2 = v6;
        if (destination$iv$iv2 != null && ($this$map$iv3 = destination$iv$iv2.getValues()) != null) {
            void $this$mapTo$iv$iv3;
            $i$f$map2 = $this$map$iv3;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                FacetField.Count bl = (FacetField.Count)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl4 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                object.add(new DriveFileTypeResultCount(SearchDriveFileType.valueOf((String)string), (Number)it.getCount()));
            }
            list2 = (List)destination$iv$iv4;
        } else {
            list2 = null;
        }
        List fileTypeResultCounts = list2;
        destination$iv$iv2 = searchResponse.getResults();
        long l = searchQueryResponse.getResults().getNumFound();
        long l2 = searchQueryResponse.getResults().getStart() + (long)searchQueryResponse.getResults().size();
        boolean $i$f$map4 = false;
        $this$map$iv2 = $this$map$iv;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            de.justsoftware.search.shared.model.SearchResult item$iv$iv2 = (de.justsoftware.search.shared.model.SearchResult)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl = false;
            Map map = parentInfo;
            SearchableId searchableId = it.getParentId();
            collection.add(SolrSearchResultDto.Companion.toDto((de.justsoftware.search.shared.model.SearchResult)it, (SearchResultParentDto)map.get(searchableId != null ? searchableId.toCanonicalId() : null)));
        }
        collection = (List)destination$iv$iv5;
        List list6 = searchTypeResultCounts;
        if (list6 == null) {
            list6 = CollectionsKt.emptyList();
        }
        if ((list = fileTypeResultCounts) == null) {
            list = CollectionsKt.emptyList();
        }
        List list7 = list;
        List list8 = list6;
        List list9 = collection;
        long l3 = l;
        long l4 = l2;
        return new SearchResult(l4, l3, list9, list8, list7);
    }

    @NotNull
    public SearchResponse search(@NotNull SearchParam searchParam) {
        Intrinsics.checkNotNullParameter((Object)searchParam, (String)"searchParam");
        QueryResponse response = this.send(SearchService.buildSolrQuery$default((SearchService)this, (SearchParam)searchParam, null, (int)2, null));
        return Companion.access$toSearchResponse((Companion)Companion, (QueryResponse)response);
    }

    private SolrQuery buildSolrQuery(SearchParam params, Function1<? super SolrQuery, Unit> configure) {
        Object[] objectArray;
        Date modifiedBefore;
        Date modifiedAfter;
        String[] stringArray;
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u248 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)params.getQuery())) {
            $this$buildSolrQuery_u24lambda_u248.setQuery(params.getQuery());
        }
        $this$buildSolrQuery_u24lambda_u248.setHighlight(true);
        String[] stringArray2 = new String[]{Companion.access$toSortField((Companion)Companion, (SortBy)params.getSortBy()) + " " + (params.getSortDirection() == SortDirection.ASC ? "asc" : "desc")};
        $this$buildSolrQuery_u24lambda_u248.add("sort", stringArray2);
        stringArray2 = new String[]{String.valueOf(params.getOffset())};
        $this$buildSolrQuery_u24lambda_u248.set("start", stringArray2);
        stringArray2 = new String[]{String.valueOf(params.getCount())};
        $this$buildSolrQuery_u24lambda_u248.set("rows", stringArray2);
        stringArray2 = new String[]{REQUESTED_FIELDS + (params.getIncludeContent() ? ", content" : "")};
        $this$buildSolrQuery_u24lambda_u248.set("fl", stringArray2);
        stringArray2 = new String[]{params.getTenantId().toCanonicalId()};
        $this$buildSolrQuery_u24lambda_u248.add("tenantId", stringArray2);
        ProfileId profileId = params.getSearcherId();
        if (profileId != null) {
            String searchRoles = CollectionsKt.joinToString$default((Iterable)this.permissionService.getSearchRoles(profileId), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            stringArray = new String[]{searchRoles};
            $this$buildSolrQuery_u24lambda_u248.add("justRoles", stringArray);
        }
        if ((modifiedAfter = params.getModifiedAfter()) != null) {
            stringArray = new String[]{"modify_date:{" + modifiedAfter.toInstant() + " TO *]"};
            $this$buildSolrQuery_u24lambda_u248.addFilterQuery(stringArray);
        }
        if ((modifiedBefore = params.getModifiedBefore()) != null) {
            objectArray = new String[]{"modify_date:[* TO " + modifiedBefore.toInstant() + "}"};
            $this$buildSolrQuery_u24lambda_u248.addFilterQuery((String[])objectArray);
        }
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"type", (Collection)params.getType(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"just_app_id", (Collection)params.getApp(), null, (int)4, null);
        objectArray = new String[]{"name", "name_substring"};
        Companion.access$addEDisMaxFilterQueries((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (List)CollectionsKt.listOf((Object[])objectArray), (String)params.getName());
        Companion.access$addEDisMaxFilterQueries((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"content", (String)params.getContent());
        Companion.access$addFieldFilterQuery((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"tags", (Collection)params.getTag(), (String)" AND ");
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"id", (Collection)params.getId(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"!id", (Collection)params.getExcludeId(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"parent_id", (Collection)params.getParentId(), null, (int)4, null);
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"searchable_fields_", (Map)params.getSearchableFields());
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"additional_fields_", (Map)params.getAdditionalFields());
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u248, (String)"!additional_fields_", (Map)params.getExcludeAdditionalFields());
        $this$buildSolrQuery_u24lambda_u248.setRequestHandler("justSearch");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u248);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(SearchService searchService, SearchParam searchParam, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n & 2) != 0) {
            function1 = SearchService::buildSolrQuery$lambda$7;
        }
        return searchService.buildSolrQuery(searchParam, function1);
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    private static final Unit search$lambda$0(Filter $filters, SolrQuery $this$buildSolrQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSolrQuery, (String)"$this$buildSolrQuery");
        String[] stringArray = new String[]{"{!ex=search_type_filter}type"};
        $this$buildSolrQuery.addFacetField(stringArray);
        stringArray = new String[]{"{!ex=file_type_filter}" + FILE_TYPE_FILTER_FIELD};
        $this$buildSolrQuery.addFacetField(stringArray);
        Filter filter = $filters;
        if ((filter != null ? filter.getApp() : null) != null) {
            stringArray = new String[]{"just_app_id:" + $filters.getApp()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        Filter filter2 = $filters;
        if ((filter2 != null ? filter2.getSearchType() : null) != null) {
            stringArray = new String[]{"{!tag=search_type_filter}type:" + $filters.getSearchType()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        Filter filter3 = $filters;
        if ((filter3 != null ? filter3.getFileType() : null) != null) {
            stringArray = new String[]{"{!tag=file_type_filter}" + FILE_TYPE_FILTER_FIELD + ":" + $filters.getFileType()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildSolrQuery$lambda$7(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ String access$getREQUESTED_FIELDS_FOR_PARENT_INFO$cp() {
        return REQUESTED_FIELDS_FOR_PARENT_INFO;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        FILE_TYPE_FILTER_FIELD = "additional_fields_" + GlobalAdditionalFields.FILE_TYPE;
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u249 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, type, just_app_id, modify_date, name, parent_id, additional_fields_*";
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_FOR_PARENT_INFO_u24lambda_u2410 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl2 = false;
        REQUESTED_FIELDS_FOR_PARENT_INFO = "id, name, type";
    }
}

