/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.ProfileAuthContext;
import de.justsoftware.publicAPI.controller.WikiController;
import de.justsoftware.publicAPI.controller.model.ArticleExportDto;
import de.justsoftware.publicAPI.exception.MissingScopeException;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.shared.model.TenantId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/wiki"})
@Tag(name="Just Wiki", description="Public API for Just Wiki contents")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/publicAPI/controller/WikiController;", "", "searchServiceInternalConnector", "Lde/justsoftware/search/shared/SearchServiceInternalConnector;", "<init>", "(Lde/justsoftware/search/shared/SearchServiceInternalConnector;)V", "exportArticles", "", "Lde/justsoftware/publicAPI/controller/model/ArticleExportDto;", "modifiedAfter", "Ljava/time/Instant;", "offset", "", "limit", "authContext", "Lde/justsoftware/publicAPI/authorization/ProfileAuthContext;", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nWikiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n1557#3:102\n1628#3,3:103\n*S KotlinDebug\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n*L\n86#1:102\n86#1:103,3\n*E\n"})
public class WikiController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchServiceInternalConnector searchServiceInternalConnector;
    public static final long MAX_EXPORT_LIMIT = 1000L;
    @NotNull
    public static final String USER_WIKI_READ_PERMISSION = "user:wiki.read";

    public WikiController(@NotNull SearchServiceInternalConnector searchServiceInternalConnector) {
        Intrinsics.checkNotNullParameter((Object)searchServiceInternalConnector, (String)"searchServiceInternalConnector");
        this.searchServiceInternalConnector = searchServiceInternalConnector;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Returns a list of all Wiki articles visible for the current user", description="This route uses the permissions of the caller and is thus currently only available with the **OAuth 2.0 Password Flow** and **OAuth 2.0 Authorization Code Flow**\n\n**Needed Scopes:** user:wiki.read")
    @ApiResponses(value={@ApiResponse(description="Successfully exported Wiki articles", responseCode="200"), @ApiResponse(description="Request validation error: one or more inputs are invalid", responseCode="400")})
    @GetMapping(value={"articles"})
    @NotNull
    public List<ArticleExportDto> exportArticles(@Parameter(name="modifiedAfter", description="Return Wiki articles modified after the given UTC datetime.", required=false, example="2018-02-26T02:00:00.000Z") @RequestParam(value="modifiedAfter", required=false) @Nullable Instant modifiedAfter, @Parameter(name="offset", description="Skip first n (offset) Wiki articles to export.", required=false) @Min(value=0L, message="Offset must be a non-negative integer") @RequestParam(value="offset", required=false, defaultValue="0") int offset, @Parameter(name="limit", description="Max number of simultaneously exported articles.", required=false) @Min(value=1L, message="Limit must be a positive integer less or equal to 1000") @Max(value=1000L, message="Limit must be a positive integer less or equal to 1000") @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull ProfileAuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.hasScope(USER_WIKI_READ_PERMISSION)) {
            throw new MissingScopeException();
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Date date;
            SortDirection p0;
            Object object;
            SearchServiceInternalConnector searchServiceInternalConnector = this.searchServiceInternalConnector;
            Object object2 = new ProfileId(((Number)authContext.getUser().getId()).longValue());
            TenantId tenantId = new TenantId((UUID)authContext.getTenantId().getId());
            Instant instant = modifiedAfter;
            if (instant != null) {
                Instant instant2 = instant;
                object = searchServiceInternalConnector;
                boolean $i$f$exportArticles$stub_for_inlining = false;
                boolean bl = false;
                date = Date.from((Instant)p0);
                searchServiceInternalConnector = object;
            } else {
                date = null;
            }
            Date date2 = date;
            Set set = SetsKt.setOf((Object)SearchType.WIKI_ARTICLE);
            p0 = SortDirection.DESC;
            SortBy $i$f$exportArticles$stub_for_inlining = SortBy.MODIFY_DATE;
            object2 = searchServiceInternalConnector.search(new SearchParam(tenantId, object2, null, set, null, null, null, null, null, null, null, null, null, null, date2, null, true, offset, limit, $i$f$exportArticles$stub_for_inlining, p0, 49140, null)).getResults();
            tenantId = ArticleExportDto.Companion;
            boolean $i$f$map = false;
            set = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p02;
                SearchResult searchResult = (SearchResult)item$iv$iv;
                object = destination$iv$iv;
                boolean $i$f$exportArticles$stub_for_inlining$0 = false;
                boolean bl = false;
                object.add(tenantId.fromSearchResult((SearchResult)p02));
            }
            return (List)destination$iv$iv;
        }
        catch (RuntimeException e) {
            if (!(!(e.getCause() instanceof DataBufferLimitException))) {
                boolean bl = false;
                String string = "Too many data loaded. Reduce the limit to avoid this error. Current limit was: " + limit + ".";
                throw new IllegalArgumentException(string.toString());
            }
            throw e;
        }
    }
}

