/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.network.http.HttpInterceptor;
import de.justsoftware.publicAPI.config.NewsGraphQLClient;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/publicAPI/config/NewsGraphQLClient;", "", "graphqlUrl", "", "<init>", "(Ljava/lang/String;)V", "baseClient", "Lcom/apollographql/apollo/ApolloClient;", "withRequest", "request", "Ljakarta/servlet/http/HttpServletRequest;", "Companion", "public-api-service"})
public class NewsGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String graphqlUrl;
    @NotNull
    private final ApolloClient baseClient;

    public NewsGraphQLClient(@Value(value="${just.news.graphql.url}") @NotNull String graphqlUrl) {
        Intrinsics.checkNotNullParameter((Object)graphqlUrl, (String)"graphqlUrl");
        this.graphqlUrl = graphqlUrl;
        this.baseClient = new ApolloClient.Builder().serverUrl(this.graphqlUrl).build();
    }

    @NotNull
    public ApolloClient withRequest(@NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.baseClient.newBuilder().addHttpInterceptor((HttpInterceptor)new Companion.GraphQLHttpInterceptor(request2)).build();
    }
}

