/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.h2;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.permission.business.item.model.Item;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.persistence.ItemDAO;
import de.justsoftware.permission.persistence.TransactionSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class H2ItemDAO
implements ItemDAO {
    private final NamedParameterJdbcTemplate _namedParameterJdbcTemplate;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public H2ItemDAO(NamedParameterJdbcTemplate namedParameterJdbcTemplate, TransactionSupport transactionSupport) {
        this._namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this._transactionSupport = transactionSupport;
    }

    public ImmutableMap<ItemId, Item> getByIds(Set<ItemId> itemIds) {
        if (itemIds.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap itemBuilderMap = new HashMap();
        this._namedParameterJdbcTemplate.query("SELECT i.id, i.parent_id, p.param FROM item i LEFT OUTER JOIN item_param p ON i.id = p.item_id WHERE i.id IN (:ids)", Collections.singletonMap("ids", this.toParam(itemIds.stream())), rs -> {
            String param;
            Item.ItemBuilder itemBuilder = itemBuilderMap.computeIfAbsent(ItemId.valueOf((String)rs.getString("id")), Item::builder);
            String parentIdString = rs.getString("parent_id");
            if (StringUtils.isNotBlank((CharSequence)parentIdString)) {
                itemBuilder.setParentId(ItemId.valueOf((String)parentIdString));
            }
            if ((param = rs.getString("param")) != null) {
                itemBuilder.addParams(new String[]{param});
            }
        });
        return ImmutableMap.copyOf((Map)Maps.transformValues(itemBuilderMap, Item.ItemBuilder::build));
    }

    public void storeItems(List<Item> items) {
        if (items.isEmpty()) {
            return;
        }
        this._transactionSupport.doInTransaction(() -> {
            SqlParameterSource[] itemBatch = (SqlParameterSource[])items.stream().map(item -> new MapSqlParameterSource().addValue("id", (Object)item.getId().asString()).addValue("parent_id", item.getParentId().map(ItemId::asString).orElse(null))).toArray(SqlParameterSource[]::new);
            this._namedParameterJdbcTemplate.batchUpdate("merge into item (id, parent_id, mtime) key(id) values(:id, :parent_id, now())", itemBatch);
            this._namedParameterJdbcTemplate.update("DELETE FROM item_param WHERE item_id in (:item_id)", Collections.singletonMap("item_id", this.toParam(items.stream().map(Item::getId))));
            SqlParameterSource[] itemParams = (SqlParameterSource[])items.stream().flatMap(item -> item.getParams().stream().map(param -> new MapSqlParameterSource("item_id", (Object)item.getId().asString()).addValue("param", param))).toArray(SqlParameterSource[]::new);
            if (itemParams.length == 0) {
                return;
            }
            this._namedParameterJdbcTemplate.batchUpdate("insert into item_param (item_id, param, mtime) values(:item_id, :param, now())", itemParams);
        });
    }

    public void deleteItems(Set<ItemId> itemIds) {
        if (itemIds.isEmpty()) {
            return;
        }
        this._namedParameterJdbcTemplate.update("delete from item where id in (:ids)", Collections.singletonMap("ids", this.toParam(itemIds.stream())));
    }

    @Nonnull
    private ImmutableSet<String> toParam(Stream<ItemId> itemIds) {
        return (ImmutableSet)itemIds.map(ItemId::asString).collect(ImmutableSet.toImmutableSet());
    }
}

