/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.h2;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.permission.persistence.ConsumerOffsetDAO;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class H2ConsumerOffsetDAO
implements ConsumerOffsetDAO {
    private final NamedParameterJdbcTemplate _namedParameterJdbcTemplate;

    @Autowired
    public H2ConsumerOffsetDAO(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this._namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public void storeOffsets(Map<String, Long> consumedOffsets) {
        if (consumedOffsets.isEmpty()) {
            return;
        }
        this._namedParameterJdbcTemplate.batchUpdate("merge into consumer_offset (topic_partition, consumer_offset, mtime) key(topic_partition) values(:topic_partition, :offset, now())", (SqlParameterSource[])consumedOffsets.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            return new MapSqlParameterSource().addValue("topic_partition", (Object)key).addValue("offset", entry.getValue());
        }).toArray(SqlParameterSource[]::new));
    }

    public ImmutableMap<String, Long> getOffsets(Set<String> topicPartitions) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        this._namedParameterJdbcTemplate.query("SELECT * FROM consumer_offset WHERE topic_partition IN (:topicPartitions)", (Map)ImmutableMap.of((Object)"topicPartitions", topicPartitions), rs -> result.put((Object)rs.getString("topic_partition"), (Object)rs.getLong("consumer_offset")));
        return result.build();
    }
}

