/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.path;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.justsoftware.permission.path.PathElement;
import de.justsoftware.permission.path.PathMatchElement;
import de.justsoftware.permission.path.PathMatcher;
import de.justsoftware.permission.path.PathResolver;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PathMatcher<T, C>
implements PathResolver<T, C> {
    public static final String ANY = "*";
    public static final String ANYANY = "**";
    public static final String EPSILON = "";
    private static final Comparator<NFAState> NFA_COMPARATOR = Comparator.comparingInt(s -> s.getPathNum());
    private final NFAState _start = new NFAState(this, context -> true);
    private int _idCount = 0;
    private int _pathCount = 0;

    @Nonnull
    private NFAState addWordState(NFAState last, PathElement<C> w) {
        NFAState next = new NFAState(this, arg_0 -> w.test(arg_0));
        last.addNextState(w.getWord(), next);
        return next;
    }

    @Nonnull
    private NFAState addAnyAnyState(NFAState last) {
        NFAState next = new NFAState(this, context -> true);
        last.addNextState(EPSILON, next);
        next.addNextState(ANY, next);
        return next;
    }

    public void add(List<? extends PathElement<C>> path, T obj) {
        NFAState currentState = this._start;
        block9: for (PathElement w : this.prepareList(path)) {
            String word;
            switch (word = w.getWord()) {
                case "": {
                    continue block9;
                }
                case "**": {
                    currentState = this.addAnyAnyState(currentState);
                    continue block9;
                }
            }
            currentState = this.addWordState(currentState, w);
        }
        currentState.setObject(obj);
    }

    @Nonnull
    protected <X> List<X> prepareList(List<X> path) {
        return path;
    }

    public Optional<T> get(List<? extends PathMatchElement<C>> path) {
        Iterable unordered = this.allUnorderedMatches(path);
        Optional<NFAState> state = StreamSupport.stream(unordered.spliterator(), false).max(NFA_COMPARATOR);
        return state.map(NFAState::getObject);
    }

    public List<T> getAllMatches(List<? extends PathMatchElement<C>> path) {
        return (List)Streams.stream((Iterable)this.allUnorderedMatches(path)).sorted(NFA_COMPARATOR).map(NFAState::getObject).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private Iterable<NFAState> allUnorderedMatches(List<? extends PathMatchElement<C>> path) {
        NFAStateSet currentState = new NFAStateSet(this);
        for (PathMatchElement w : this.prepareList(path)) {
            if (w.getWord().equals(EPSILON)) continue;
            currentState = currentState.nextStateSet(w);
        }
        return Iterables.filter((Iterable)currentState.getStates(), NFAState::isEndState);
    }
}

