/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.role.model;

import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.item.model.ItemType;
import de.justsoftware.permission.business.role.model.AbstractRole;
import de.justsoftware.permission.business.role.model.ProfileRole;
import de.justsoftware.permission.business.role.model.Role;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ProfileIdentityRole
extends AbstractRole {
    private static final ItemType PROFILE_ITEM_TYPE = ItemType.get((String)"PROFILE");
    private static final String IDENTITY_ROLE_NAME = "IDENTITY@" + String.valueOf(PROFILE_ITEM_TYPE) + ",*";

    ProfileIdentityRole() {
        super(IDENTITY_ROLE_NAME);
    }

    public void accept(Role.Visitor visitor) {
        visitor.visitProfileIdentityRole(this);
    }

    @Nonnull
    public ProfileRole withItem(ItemId itemId) {
        return new ProfileRole(itemId.asString());
    }

    @Nonnull
    public static Optional<ProfileIdentityRole> parse(String role) {
        if (IDENTITY_ROLE_NAME.equals(role)) {
            return Optional.of(new ProfileIdentityRole());
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemType getItemType() {
        return PROFILE_ITEM_TYPE;
    }
}

