/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.config.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.permission.business.config.ConfigService;
import de.justsoftware.permission.business.config.model.ConfigForItemType;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.item.model.Item;
import de.justsoftware.permission.business.item.model.ItemType;
import de.justsoftware.permission.business.role.model.PathResolvableRole;
import de.justsoftware.permission.path.PathMatchElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ConfigServiceImpl
implements ConfigService {
    private final ConcurrentHashMap<ItemType, ConfigForItemType> _pathReplacements = new ConcurrentHashMap();

    public synchronized void replaceConfig(ItemType itemType, ConfigForItemType configForItem) {
        this._pathReplacements.merge(itemType, configForItem, (oldConfig, newConfig) -> oldConfig.equals(newConfig) ? oldConfig : newConfig);
    }

    public Replacement get(List<Item> path, PathResolvableRole role) {
        ArrayList<PathMatchElement> pathMatcherElements = new ArrayList<PathMatchElement>(path.size() + 1);
        for (Item item : path) {
            pathMatcherElements.add(ConfigServiceImpl.itemPathMatchElement((Item)item));
        }
        pathMatcherElements.add(new PathMatchElement(role.getPathResolvableName(), (Object)ImmutableSet.of()));
        for (Item item : path) {
            Optional r;
            ConfigForItemType configPerItem = (ConfigForItemType)this._pathReplacements.get(item.getType());
            if (configPerItem == null || !(r = configPerItem.getPathResolver().get(pathMatcherElements)).isPresent()) continue;
            return (Replacement)r.get();
        }
        return Replacement.EMPTY;
    }

    @Nonnull
    private static PathMatchElement<ImmutableSet<String>> itemPathMatchElement(Item item) {
        return new PathMatchElement(item.getType().asString(), (Object)item.getParams());
    }
}

