/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka;

import de.justsoftware.news.kafka.KafkaProducerConfiguration;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.annotation.EnableKafka;

@Configuration
@EnableKafka
@DependsOn(value={"liquibase"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\nB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/kafka/KafkaProducerConfiguration;", "", "bootstrapServers", "", "<init>", "(Ljava/lang/String;)V", "stringProducer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "closingKafkaProducerConfig", "Ljava/util/Properties;", "ClosingKafkaProducer", "news-service"})
public class KafkaProducerConfiguration {
    @NotNull
    private final String bootstrapServers;

    public KafkaProducerConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaProducer<String, String> stringProducer() {
        return (KafkaProducer)new ClosingKafkaProducer(this.closingKafkaProducerConfig(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    }

    private Properties closingKafkaProducerConfig() {
        Properties properties;
        Properties $this$closingKafkaProducerConfig_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$closingKafkaProducerConfig_u24lambda_u240.put("bootstrap.servers", this.bootstrapServers);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("acks", "all");
        $this$closingKafkaProducerConfig_u24lambda_u240.put("retries", (Object)0);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("batch.size", (Object)16384);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("linger.ms", (Object)1);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("buffer.memory", (Object)0x2000000);
        return properties;
    }
}

