/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.news.generated.fragment.ChannelFragment;
import de.justsoftware.mobile.gateway.news.generated.fragment.CommentFragment;
import de.justsoftware.mobile.gateway.news.generated.fragment.PostFragment;
import de.justsoftware.mobile.gateway.news.model.local.AddPostData;
import de.justsoftware.mobile.gateway.news.model.local.Channel;
import de.justsoftware.mobile.gateway.news.model.local.Comment;
import de.justsoftware.mobile.gateway.news.model.local.CommentContent;
import de.justsoftware.mobile.gateway.news.model.local.Feed;
import de.justsoftware.mobile.gateway.news.model.local.NewsConfig;
import de.justsoftware.mobile.gateway.news.model.local.PinPostData;
import de.justsoftware.mobile.gateway.news.model.local.Poll;
import de.justsoftware.mobile.gateway.news.model.local.Post;
import de.justsoftware.mobile.gateway.news.model.local.UpdateEventAttendanceData;
import de.justsoftware.mobile.gateway.news.model.local.UpdatePostData;
import de.justsoftware.mobile.gateway.news.model.remote.AttendeesKt;
import de.justsoftware.mobile.gateway.news.model.remote.ChannelFragmentsKt;
import de.justsoftware.mobile.gateway.news.model.remote.CommentFragmentsKt;
import de.justsoftware.mobile.gateway.news.model.remote.LikeFragmentsKt;
import de.justsoftware.mobile.gateway.news.model.remote.NewsProfileFragmentsKt;
import de.justsoftware.mobile.gateway.news.model.remote.PostFragmentsKt;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.util.ListsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0012H\u0016JH\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010#\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010(\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0012H\u0016J \u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010'\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J4\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010'\u001a\u00020\u00122\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u0002012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J$\u00102\u001a\u0004\u0018\u00010-2\u0006\u00103\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J(\u00104\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010'\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u00105\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u00107\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u00108\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u00109\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010<\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010=\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010>\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0012H\u0016J8\u0010@\u001a\u00020A2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u00122\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J.\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010F\u001a\u00020\u0012H\u0016J\u0010\u0010G\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020E0\u00142\u0006\u0010'\u001a\u00020\u0012H\u0016J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020E0\u00142\u0006\u00103\u001a\u00020\u0012H\u0016J0\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010K\u001a\b\u0012\u0004\u0012\u00020E0\u00142\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J*\u0010L\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010M\u001a\u00020N2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0012J\"\u0010P\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lde/justsoftware/mobile/gateway/news/service/NewsService;", "", "gatewayService", "Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "<init>", "(Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;Lde/justsoftware/mobile/gateway/common/service/UrlService;)V", "getConfig", "Lde/justsoftware/mobile/gateway/news/model/local/NewsConfig;", "getFeed", "Lde/justsoftware/mobile/gateway/news/model/local/Feed;", "offset", "", "limit", "locale", "Ljava/util/Locale;", "translationLanguage", "", "getPinnedFeed", "", "Lde/justsoftware/mobile/gateway/news/model/local/Post;", "markFeedAsRead", "", "getChannels", "Lde/justsoftware/mobile/gateway/news/model/local/Channel;", "subscribe", "channelId", "notificationsEnabled", "", "unsubscribe", "getChannel", "getChannelPosts", "scheduled", "pinned", "addPost", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/local/AddPostData;", "getPost", "postId", "updatePost", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/local/UpdatePostData;", "deletePost", "getComments", "Lde/justsoftware/mobile/gateway/news/model/local/Comment;", "addComment", "referenceId", "content", "Lde/justsoftware/mobile/gateway/news/model/local/CommentContent;", "updateComment", "commentId", "deleteComment", "enableCommentNotifications", "enabled", "likePost", "unlikePost", "pinPost", "pinPostData", "Lde/justsoftware/mobile/gateway/news/model/local/PinPostData;", "unpinPost", "likeComment", "unlikeComment", "markPostAsRead", "voteForPoll", "Lde/justsoftware/mobile/gateway/news/model/local/Poll;", "pollId", "answerIds", "getChannelSubscribers", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "getChannelSubscribersCount", "getPostLikers", "getCommentLikers", "getEvents", "getEventAttendees", "updateEventAttendance", "updateEventAttendanceData", "Lde/justsoftware/mobile/gateway/news/model/local/UpdateEventAttendanceData;", "getWriteableChannels", "getComment", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNewsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,496:1\n1#2:497\n774#3:498\n865#3,2:499\n183#4,2:501\n*S KotlinDebug\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n*L\n476#1:498\n476#1:499,2\n491#1:501,2\n*E\n"})
public class NewsService {
    @NotNull
    private final NewsApiGatewayService gatewayService;
    @NotNull
    private final UrlService urlService;

    public NewsService(@NotNull NewsApiGatewayService gatewayService, @NotNull UrlService urlService) {
        Intrinsics.checkNotNullParameter((Object)gatewayService, (String)"gatewayService");
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        this.gatewayService = gatewayService;
        this.urlService = urlService;
    }

    @NotNull
    public NewsConfig getConfig() {
        return (NewsConfig)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public Feed getFeed(int offset, int limit, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        List p0 = PostFragmentsKt.toPosts((List)this.gatewayService.getFeed(offset, limit, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean bl = false;
        return new Feed(p0);
    }

    @NotNull
    public List<Post> getPinnedFeed(int offset, int limit, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPosts((List)this.gatewayService.getPinnedFeed(offset, limit, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void markFeedAsRead() {
        this.gatewayService.markFeedAsRead();
    }

    @NotNull
    public List<Channel> getChannels() {
        return ChannelFragmentsKt.toChannels((List)this.gatewayService.getChannels(), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Channel subscribe(@NotNull String channelId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return ChannelFragmentsKt.toChannel((ChannelFragment)this.gatewayService.subscribe(channelId, notificationsEnabled), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Channel unsubscribe(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return ChannelFragmentsKt.toChannel((ChannelFragment)this.gatewayService.unsubscribe(channelId), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Channel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return ChannelFragmentsKt.toChannel((ChannelFragment)this.gatewayService.getChannel(channelId), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public List<Post> getChannelPosts(@NotNull String channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPosts((List)this.gatewayService.getPosts(channelId, offset, limit, scheduled, pinned, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Post addPost(@NotNull String channelId, @NotNull AddPostData addPostData, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.addPost(channelId, addPostData, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    @NotNull
    public Post getPost(@NotNull String postId, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.getPost(postId, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    @NotNull
    public Post updatePost(@NotNull String postId, @NotNull UpdatePostData updatePostData, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.updatePost(postId, updatePostData, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    public void deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.deletePost(postId);
    }

    @NotNull
    public List<Comment> getComments(@NotNull String postId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return CommentFragmentsKt.toComments((List)this.gatewayService.getComments(postId, translationLanguage));
    }

    @NotNull
    public List<Comment> addComment(@NotNull String postId, @Nullable String referenceId, @NotNull CommentContent content, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.gatewayService.addComment(postId, referenceId, content);
        return this.getComments(postId, translationLanguage);
    }

    public static /* synthetic */ List addComment$default(NewsService newsService, String string, String string2, CommentContent commentContent, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addComment");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return newsService.addComment(string, string2, commentContent, string3);
    }

    @Nullable
    public Comment updateComment(@NotNull String commentId, @NotNull CommentContent content, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return CommentFragmentsKt.toComment$default((CommentFragment)this.gatewayService.updateComment(commentId, content, translationLanguage), (boolean)false, (int)1, null);
    }

    @NotNull
    public List<Comment> deleteComment(@NotNull String postId, @NotNull String commentId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.deleteComment(commentId);
        return this.getComments(postId, translationLanguage);
    }

    @NotNull
    public Post enableCommentNotifications(@NotNull String postId, boolean enabled, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.enableCommentNotifications(postId, enabled, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    @NotNull
    public Post likePost(@NotNull String postId, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.gatewayService.like(postId);
        return this.getPost(postId, locale, translationLanguage);
    }

    @NotNull
    public Post unlikePost(@NotNull String postId, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.gatewayService.unlike(postId);
        return this.getPost(postId, locale, translationLanguage);
    }

    @NotNull
    public Post pinPost(@NotNull String postId, @NotNull Locale locale, @NotNull PinPostData pinPostData, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)pinPostData, (String)"pinPostData");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.pinPost(postId, true, locale, pinPostData, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    @NotNull
    public Post unpinPost(@NotNull String postId, @NotNull Locale locale, @NotNull PinPostData pinPostData, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)pinPostData, (String)"pinPostData");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.pinPost(postId, false, locale, pinPostData, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    @NotNull
    public Comment likeComment(@NotNull String postId, @NotNull String commentId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.like(commentId);
        return this.getComment(postId, commentId, translationLanguage);
    }

    @NotNull
    public Comment unlikeComment(@NotNull String postId, @NotNull String commentId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.unlike(commentId);
        return this.getComment(postId, commentId, translationLanguage);
    }

    public void markPostAsRead(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.markPostAsRead(postId);
    }

    @NotNull
    public Poll voteForPoll(@NotNull String postId, @NotNull String pollId, @NotNull List<String> answerIds, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(answerIds, (String)"answerIds");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (Poll)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<Profile> getChannelSubscribers(@NotNull String channelId, int offset, int limit, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List list = this.gatewayService.getChannelSubscribers(channelId, offset, limit, query);
        List list2 = list != null ? NewsProfileFragmentsKt.toProfiles((List)list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public int getChannelSubscribersCount(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Integer n = this.gatewayService.getChannelSubscribersCount(channelId);
        return n != null ? n : 0;
    }

    @NotNull
    public List<Profile> getPostLikers(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return LikeFragmentsKt.toProfiles((List)this.gatewayService.getLikers(postId));
    }

    @NotNull
    public List<Profile> getCommentLikers(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return LikeFragmentsKt.toProfiles((List)this.gatewayService.getLikers(commentId));
    }

    @NotNull
    public List<Post> getEvents(int offset, int limit, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPosts((List)this.gatewayService.getEvents(offset, limit, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public List<Profile> getEventAttendees(@NotNull String postId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AttendeesKt.toProfiles((List)ListsKt.page((List)this.gatewayService.getEventAttendees(postId), (int)offset, (int)limit));
    }

    @NotNull
    public Post updateEventAttendance(@NotNull String postId, @NotNull UpdateEventAttendanceData updateEventAttendanceData, @NotNull Locale locale, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updateEventAttendanceData, (String)"updateEventAttendanceData");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PostFragmentsKt.toPost$default((PostFragment)this.gatewayService.updateEventAttendance(postId, updateEventAttendanceData, locale, translationLanguage), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private List<Channel> getWriteableChannels() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ChannelFragmentsKt.toChannels((List)this.gatewayService.getChannels(), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Channel channel = (Channel)element$iv$iv;
            boolean bl = false;
            if (!(channel.getMayCreatePost() || channel.getMayCreateEvent())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Comment getComment(String postId, String commentId, String translationLanguage) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.getComments(postId, translationLanguage)), NewsService::getComment$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Comment it = (Comment)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)commentId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Comment comment = v0;
        if (comment == null) {
            throw new NotFoundException("Comment with id " + commentId + " does not exist for post " + postId + ".");
        }
        return comment;
    }

    private static final Iterable getComment$lambda$0(Comment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Collection collection = CollectionsKt.listOf((Object)comment);
        List list = comment.getResponses();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    public static final /* synthetic */ NewsApiGatewayService access$getGatewayService$p(NewsService $this) {
        return $this.gatewayService;
    }

    public static final /* synthetic */ List access$getWriteableChannels(NewsService $this) {
        return $this.getWriteableChannels();
    }
}

