/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.desktop.service;

import de.justsoftware.mobile.gateway.common.model.IdType;
import de.justsoftware.mobile.gateway.desktop.model.ResolvedDesktopHash;
import de.justsoftware.mobile.gateway.desktop.service.DesktopHashResolverService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0012\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/mobile/gateway/desktop/service/DesktopHashResolverService;", "", "<init>", "()V", "resolveDesktopHash", "Lde/justsoftware/mobile/gateway/desktop/model/ResolvedDesktopHash;", "desktopHash", "", "resolveDrivePreviewHash", "resolveHomescreenHash", "resolveDriveHash", "resolveNewsHash", "resolveWikiHash", "resolvePeopleHash", "resolveChatHash", "Companion", "mobile-gateway"})
public class DesktopHashResolverService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex DRIVE_URL = new Regex("^#?/drive(?:/(file|folder)/([0-9A-Fa-f-]*))?");
    @NotNull
    private static final Regex DRIVE_PREVIEW_URL = new Regex(".*[?&]previewDocumentId=([0-9A-Fa-f-]*).*");
    @NotNull
    private static final Regex HOMESCREEN_URL = new Regex("^#?/homescreen\\?*(.*)");
    @NotNull
    private static final Regex NEWS_URL = new Regex("^#?/news/(feed|channels|channel|posts|events)/?([^/#%]*)?/?.*");
    @NotNull
    private static final Regex WIKI_URL = new Regex("^#?/wiki(?:/(wikis|chapters|articles|subscriptions)?/?([^?]+)?\\??(.+)?)?$");
    @NotNull
    private static final Regex PEOPLE_URL = new Regex("^#?/people/(profile|groups|users|birthday-list)/?(.+)?");
    @NotNull
    private static final Regex CHAT_URL = new Regex("^#?/chat/?(.*)?");

    @NotNull
    public ResolvedDesktopHash resolveDesktopHash(@NotNull String desktopHash) {
        Intrinsics.checkNotNullParameter((Object)desktopHash, (String)"desktopHash");
        ResolvedDesktopHash resolvedDesktopHash = this.resolveDrivePreviewHash(desktopHash);
        if (resolvedDesktopHash == null && (resolvedDesktopHash = this.resolveHomescreenHash(desktopHash)) == null && (resolvedDesktopHash = this.resolveDriveHash(desktopHash)) == null && (resolvedDesktopHash = this.resolveNewsHash(desktopHash)) == null && (resolvedDesktopHash = this.resolveWikiHash(desktopHash)) == null && (resolvedDesktopHash = this.resolvePeopleHash(desktopHash)) == null && (resolvedDesktopHash = this.resolveChatHash(desktopHash)) == null) {
            resolvedDesktopHash = (ResolvedDesktopHash)ResolvedDesktopHash.Unsupported.INSTANCE;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolveDrivePreviewHash(String desktopHash) {
        ResolvedDesktopHash.File file;
        MatchResult matchResult = Regex.find$default((Regex)DRIVE_PREVIEW_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String id = (String)matchResult2.getMatch().getGroupValues().get(1);
            file = ((CharSequence)id).length() > 0 ? new ResolvedDesktopHash.File(id) : null;
        } else {
            file = null;
        }
        return (ResolvedDesktopHash)file;
    }

    private ResolvedDesktopHash resolveHomescreenHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)HOMESCREEN_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String type = (String)matchResult2.getMatch().getGroupValues().get(1);
            resolvedDesktopHash = Intrinsics.areEqual((Object)type, (Object)"notification") ? (ResolvedDesktopHash)ResolvedDesktopHash.NotificationCenter.INSTANCE : (ResolvedDesktopHash)ResolvedDesktopHash.Start.INSTANCE;
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolveDriveHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)DRIVE_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String type = (String)matchResult2.getMatch().getGroupValues().get(1);
            String id = (String)matchResult2.getMatch().getGroupValues().get(2);
            resolvedDesktopHash = Intrinsics.areEqual((Object)type, (Object)"file") && ((CharSequence)id).length() > 0 ? (ResolvedDesktopHash)new ResolvedDesktopHash.File(id) : (Intrinsics.areEqual((Object)type, (Object)"folder") && ((CharSequence)id).length() > 0 ? (ResolvedDesktopHash)new ResolvedDesktopHash.Folder(id) : (ResolvedDesktopHash)ResolvedDesktopHash.Shares.INSTANCE);
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolveNewsHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)NEWS_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String type = (String)matchResult2.getMatch().getGroupValues().get(1);
            String id = (String)matchResult2.getMatch().getGroupValues().get(2);
            if (Intrinsics.areEqual((Object)type, (Object)"feed")) {
                resolvedDesktopHash = (ResolvedDesktopHash)ResolvedDesktopHash.NewsFeed.INSTANCE;
            } else if (Intrinsics.areEqual((Object)type, (Object)"events")) {
                resolvedDesktopHash = (ResolvedDesktopHash)ResolvedDesktopHash.NewsEvents.INSTANCE;
            } else if (Intrinsics.areEqual((Object)type, (Object)"channels")) {
                resolvedDesktopHash = (ResolvedDesktopHash)ResolvedDesktopHash.NewsChannels.INSTANCE;
            } else if (Intrinsics.areEqual((Object)type, (Object)"channel") && ((CharSequence)id).length() > 0) {
                resolvedDesktopHash = (ResolvedDesktopHash)new ResolvedDesktopHash.NewsChannel(IdType.Companion.asNewsChannelId(id));
            } else if (Intrinsics.areEqual((Object)type, (Object)"posts") && ((CharSequence)id).length() > 0) {
                String it = IdType.Companion.asNewsPostId(id);
                boolean bl2 = false;
                resolvedDesktopHash = Companion.access$hasComments((Companion)Companion, (String)desktopHash) ? (ResolvedDesktopHash)new ResolvedDesktopHash.NewsPostComments(it) : (ResolvedDesktopHash)new ResolvedDesktopHash.NewsPost(it);
            } else {
                resolvedDesktopHash = (ResolvedDesktopHash)ResolvedDesktopHash.Unsupported.INSTANCE;
            }
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolveWikiHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)WIKI_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String type = (String)matchResult2.getMatch().getGroupValues().get(1);
            String id = (String)matchResult2.getMatch().getGroupValues().get(2);
            String params = (String)matchResult2.getMatch().getGroupValues().get(3);
            resolvedDesktopHash = ((CharSequence)type).length() == 0 ? (ResolvedDesktopHash)ResolvedDesktopHash.Wikis.INSTANCE : (Intrinsics.areEqual((Object)type, (Object)"subscriptions") ? (ResolvedDesktopHash)ResolvedDesktopHash.WikiSubscriptions.INSTANCE : (((CharSequence)id).length() == 0 ? (ResolvedDesktopHash)ResolvedDesktopHash.Wikis.INSTANCE : (IdType.Companion.hasIdType(id, IdType.WIKI) ? (ResolvedDesktopHash)new ResolvedDesktopHash.Wiki(id) : (IdType.Companion.hasIdType(id, IdType.WIKI_ARTICLE) ? (ResolvedDesktopHash)new ResolvedDesktopHash.WikiArticle(id, Companion.access$findHeadingId((Companion)Companion, (String)params)) : (IdType.Companion.hasIdType(id, IdType.WIKI_CHAPTER) ? (ResolvedDesktopHash)new ResolvedDesktopHash.WikiChapter(id) : (ResolvedDesktopHash)ResolvedDesktopHash.Unsupported.INSTANCE)))));
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolvePeopleHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)PEOPLE_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String type = (String)matchResult2.getMatch().getGroupValues().get(1);
            String id = (String)matchResult2.getMatch().getGroupValues().get(2);
            resolvedDesktopHash = Intrinsics.areEqual((Object)type, (Object)"profile") && ((CharSequence)id).length() > 0 ? (ResolvedDesktopHash)new ResolvedDesktopHash.Profile(IdType.Companion.asProfileId(id)) : (Intrinsics.areEqual((Object)type, (Object)"groups") && ((CharSequence)id).length() == 0 ? (ResolvedDesktopHash)ResolvedDesktopHash.PeopleGroups.INSTANCE : (Intrinsics.areEqual((Object)type, (Object)"groups") && ((CharSequence)id).length() > 0 ? (ResolvedDesktopHash)new ResolvedDesktopHash.UserGroup(IdType.Companion.asUserGroupId(id)) : (Intrinsics.areEqual((Object)type, (Object)"users") ? (ResolvedDesktopHash)ResolvedDesktopHash.PeopleUsers.INSTANCE : (Intrinsics.areEqual((Object)type, (Object)"birthday-list") ? (ResolvedDesktopHash)ResolvedDesktopHash.PeopleBirthdays.INSTANCE : (ResolvedDesktopHash)ResolvedDesktopHash.Unsupported.INSTANCE))));
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }

    private ResolvedDesktopHash resolveChatHash(String desktopHash) {
        ResolvedDesktopHash resolvedDesktopHash;
        MatchResult matchResult = Regex.find$default((Regex)CHAT_URL, (CharSequence)desktopHash, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            String id = (String)matchResult2.getMatch().getGroupValues().get(1);
            resolvedDesktopHash = ((CharSequence)id).length() > 0 ? (ResolvedDesktopHash)new ResolvedDesktopHash.Chat(id) : (ResolvedDesktopHash)ResolvedDesktopHash.Unsupported.INSTANCE;
        } else {
            resolvedDesktopHash = null;
        }
        return resolvedDesktopHash;
    }
}

