/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.persistence.model.DbScimUserResource;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

@ParametersAreNonnullByDefault
public interface ScimUserResourceRepository
extends JpaRepository<DbScimUserResource, UUID> {
    @Nonnull
    default public Optional<DbScimUserResource> byTenantIdAndProfileId(TenantId tenantId, UUID profileId) {
        return this.findByProfileIdAndTenantId(profileId, (UUID)tenantId.getId());
    }

    @Nonnull
    default public Optional<DbScimUserResource> byTenantIdAndUserName(TenantId tenantId, String userName) {
        return this.findByTenantIdAndUserName((UUID)tenantId.getId(), userName);
    }

    @Nonnull
    @Query(value="    SELECT * FROM scim_user_resource\n    WHERE data ->> 'userName' = :userName\n    AND tenant_id = :tenantId\n", nativeQuery=true)
    public Optional<DbScimUserResource> findByTenantIdAndUserName(UUID var1, String var2);

    @Nonnull
    default public Optional<DbScimUserResource> byTenantIdAndExternalId(TenantId tenantId, @Nullable String externalId) {
        return externalId == null ? Optional.empty() : this.findByTenantIdAndExternalId((UUID)tenantId.getId(), externalId);
    }

    @Nonnull
    @Query(value="    SELECT * FROM scim_user_resource\n    WHERE data ->> 'externalId' = :externalId\n    AND tenant_id = :tenantId\n", nativeQuery=true)
    public Optional<DbScimUserResource> findByTenantIdAndExternalId(UUID var1, String var2);

    @Nonnull
    public Optional<DbScimUserResource> findByProfileId(UUID var1);

    @Nonnull
    public Optional<DbScimUserResource> findByProfileIdAndTenantId(UUID var1, UUID var2);

    @Nonnull
    default public List<DbScimUserResource> allByTenantId(TenantId tenantId) {
        return this.findByTenantId((UUID)tenantId.getId(), Pageable.unpaged()).stream().toList();
    }

    @Nonnull
    default public Page<DbScimUserResource> allByTenantId(TenantId tenantId, Pageable pageRequest) {
        return this.findByTenantId((UUID)tenantId.getId(), pageRequest);
    }

    @Transactional
    default public void delete(UUID profileId, TenantId tenantId) {
        this.deleteByProfileIdAndTenantId(profileId, (UUID)tenantId.getId());
    }

    @Transactional
    public void deleteByProfileIdAndTenantId(UUID var1, UUID var2);

    @Nonnull
    public List<DbScimUserResource> findByTenantId(UUID var1);

    @Nonnull
    public Page<DbScimUserResource> findByTenantId(UUID var1, Pageable var2);
}

