/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.common;

import de.justsoftware.justimport.domain.model.common.ItemType;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class IdParser {
    @Nonnull
    public static <ID> ID parse(ItemType type, @Nullable String idStr, Function<String, ID> constructor) {
        if (idStr != null) {
            String[] parts = idStr.split(",");
            if (parts.length == 1) {
                return constructor.apply(parts[0]);
            }
            if (parts.length == 2 && type.name().equals(parts[0])) {
                return constructor.apply(parts[1]);
            }
        }
        throw new IllegalArgumentException("Could not parse '" + idStr + "'. Expected a " + String.valueOf(type) + " id");
    }
}

