/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.controller;

import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.types.BulkConfig;
import com.unboundid.scim2.common.types.ChangePasswordConfig;
import com.unboundid.scim2.common.types.ETagConfig;
import com.unboundid.scim2.common.types.FilterConfig;
import com.unboundid.scim2.common.types.PatchConfig;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.common.types.SortConfig;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaAwareFilterEvaluator;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.config.ConfigPropertiesFromZookeeper;
import de.justsoftware.justimport.controller.ScimGroupsController;
import de.justsoftware.justimport.controller.ScimUsersController;
import de.justsoftware.justimport.util.ResourcePreparer;
import jakarta.annotation.Nullable;
import java.beans.IntrospectionException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/api/scim/v2"})
public class ScimController {
    private static final String RESOURCE_TYPES_PATH = "/scim/v2/ResourceTypes";
    private static final String SCHEMAS_TYPES_PATH = "/scim/v2/Schemas";
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION;
    private static final Logger LOG;
    private static final ResourceTypeDefinition SCHEMAS_TYPE_DEFINITION;
    private static final String DOCUMENTATION_URL = "https://support.just.social/hc/de/articles/14798826209426";
    private final ConfigPropertiesFromZookeeper _config;

    public ScimController(ConfigPropertiesFromZookeeper config) {
        this._config = config;
    }

    @GetMapping(value={"/scimEnabled"})
    public boolean isScimEnabled(AuthorizationContext authCtx) {
        LOG.warn("\ud83d\udea8 isScimEnabled: Currently ignoring TenantId {}.", (Object)authCtx.tenantId());
        return this._config.isScimEnabled();
    }

    @GetMapping(value={"/ServiceProviderConfig"})
    public ServiceProviderConfigResource getServiceProviderConfig(AuthorizationContext authCtx) {
        return new ServiceProviderConfigResource("https://support.just.social/hc/de/articles/14798826209426", new PatchConfig(true), new BulkConfig(false, 0, 0), new FilterConfig(false, 0), new ChangePasswordConfig(false), new SortConfig(false), new ETagConfig(false), null);
    }

    @GetMapping(value={"/Schemas"})
    public ListResponse<GenericScimResource> getSchemas(AuthorizationContext authCtx, @RequestParam(value="filter", required=false) @Nullable String filter) throws ForbiddenException, BadRequestException {
        LOG.warn("\ud83d\udea8 getSchemas: Currently ignoring TenantId {}.", (Object)authCtx.tenantId());
        if (filter != null) {
            throw new ForbiddenException("Filtering not allowed");
        }
        ResourcePreparer resourcePreparer = this.getResourcePreparer(SCHEMAS_TYPE_DEFINITION, "/scim/v2/Schemas");
        Set schemas = ScimController.getSchemas();
        List<GenericScimResource> preparedResources = schemas.stream().map(schema -> {
            GenericScimResource preparedResource = schema.asGenericScimResource();
            resourcePreparer.setResourceTypeAndLocation((ScimResource)preparedResource);
            return preparedResource;
        }).toList();
        return new ListResponse(preparedResources);
    }

    @GetMapping(value={"/Schemas/{id}"})
    public GenericScimResource getSchema(@PathVariable(value="id") String id, AuthorizationContext authCtx) throws ScimException {
        LOG.warn("\ud83d\udea8 getSchema: Currently ignoring TenantId {}.", (Object)authCtx.tenantId());
        Filter filter = Filter.or((Filter)Filter.eq((String)"id", (String)id), (Filter)Filter.eq((String)"name", (String)id), (Filter[])new Filter[0]);
        SchemaAwareFilterEvaluator filterEvaluator = new SchemaAwareFilterEvaluator(SCHEMAS_TYPE_DEFINITION);
        ResourcePreparer resourcePreparer = this.getResourcePreparer(SCHEMAS_TYPE_DEFINITION, "/scim/v2/Schemas");
        Set schemas = ScimController.getSchemas();
        for (SchemaResource schema : schemas) {
            GenericScimResource resource = schema.asGenericScimResource();
            if (!((Boolean)filter.visit((FilterVisitor)filterEvaluator, (Object)resource.getObjectNode())).booleanValue()) continue;
            resourcePreparer.setResourceTypeAndLocation((ScimResource)resource);
            return resource;
        }
        throw new ResourceNotFoundException("No schema defined with ID or name " + id);
    }

    @GetMapping(value={"/ResourceTypes"})
    public ListResponse<GenericScimResource> getResourceTypes(AuthorizationContext authCtx, @RequestParam(value="filter", required=false) @Nullable String filter) throws ForbiddenException, BadRequestException {
        LOG.warn("\ud83d\udea8 getResourceTypes: Currently ignoring TenantId {}.", (Object)authCtx.tenantId());
        if (filter != null) {
            throw new ForbiddenException("Filtering not allowed");
        }
        ResourcePreparer resourcePreparer = this.getResourcePreparer(RESOURCE_TYPE_DEFINITION, "/scim/v2/ResourceTypes");
        List resourceTypes = ScimController.getResourceTypes();
        List<GenericScimResource> preparedResources = resourceTypes.stream().map(resourceType -> {
            GenericScimResource preparedResource = resourceType.asGenericScimResource();
            resourcePreparer.setResourceTypeAndLocation((ScimResource)preparedResource);
            return preparedResource;
        }).toList();
        return new ListResponse(preparedResources);
    }

    @GetMapping(value={"/ResourceTypes/{id}"})
    public GenericScimResource getResourceType(@PathVariable(value="id") String id, AuthorizationContext authCtx) throws ScimException {
        LOG.warn("\ud83d\udea8 getResourceType: Currently ignoring TenantId {}.", (Object)authCtx.tenantId());
        Filter filter = Filter.or((Filter)Filter.eq((String)"id", (String)id), (Filter)Filter.eq((String)"name", (String)id), (Filter[])new Filter[0]);
        SchemaAwareFilterEvaluator filterEvaluator = new SchemaAwareFilterEvaluator(RESOURCE_TYPE_DEFINITION);
        ResourcePreparer resourcePreparer = this.getResourcePreparer(RESOURCE_TYPE_DEFINITION, "/scim/v2/ResourceTypes");
        List resourceTypes = ScimController.getResourceTypes();
        for (ResourceTypeResource resourceType : resourceTypes) {
            GenericScimResource resource = resourceType.asGenericScimResource();
            if (!((Boolean)filter.visit((FilterVisitor)filterEvaluator, (Object)resource.getObjectNode())).booleanValue()) continue;
            resourcePreparer.setResourceTypeAndLocation((ScimResource)resource);
            return resource;
        }
        throw new ResourceNotFoundException("No resource type defined with ID or name " + id);
    }

    @Nonnull
    private static List<ResourceTypeResource> getResourceTypes() {
        return ScimController.getResourceTypeDefinitions().stream().map(ResourceTypeDefinition::toScimResource).toList();
    }

    @Nonnull
    private static Set<SchemaResource> getSchemas() {
        List resources = ScimController.getResourceTypeDefinitions();
        HashSet<SchemaResource> schemas = new HashSet<SchemaResource>();
        resources.forEach(resourceTypeDefinition -> {
            if (resourceTypeDefinition.getCoreSchema() != null) {
                schemas.add(resourceTypeDefinition.getCoreSchema());
            }
            schemas.addAll(resourceTypeDefinition.getSchemaExtensions().keySet());
        });
        return schemas;
    }

    @Nonnull
    private static List<ResourceTypeDefinition> getResourceTypeDefinitions() {
        return Stream.of(ScimUsersController.USER_RESOURCE_TYPE_DEFINITION, ScimGroupsController.GROUP_RESOURCE_TYPE_DEFINITION).filter(ResourceTypeDefinition::isDiscoverable).toList();
    }

    @Nonnull
    private ResourcePreparer<GenericScimResource> getResourcePreparer(ResourceTypeDefinition resourceTypeDefinition, String resourcePath) throws BadRequestException {
        UriComponentsBuilder uriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path(resourcePath);
        return new ResourcePreparer(resourceTypeDefinition, null, null, uriBuilder.build(new Object[0]));
    }

    static {
        LOG = LoggerFactory.getLogger(ScimController.class);
        try {
            RESOURCE_TYPE_DEFINITION = new ResourceTypeDefinition.Builder("ResourceTypeResource", "/scim/v2/ResourceTypes").setCoreSchema(SchemaUtils.getSchema(ResourceTypeResource.class)).build();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        try {
            SCHEMAS_TYPE_DEFINITION = new ResourceTypeDefinition.Builder("SchemaResource", "/scim/v2/Schemas").setCoreSchema(SchemaUtils.getSchema(SchemaResource.class)).build();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }
}

