/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business;

import de.justsoftware.justimport.business.UserGroupImportConfig;
import de.justsoftware.justimport.business.UserGroupImportConfigProperties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.Name;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.ldap.support.LdapUtils;

@ParametersAreNonnullByDefault
@ConfigurationProperties(value="just.import.usergroup")
public class UserGroupImportConfigProperties
implements UserGroupImportConfig {
    private LdapConfig _ldap = new LdapConfig();
    private String _externalId = "objectGUID";

    @Nonnull
    public LdapConfig getLdap() {
        return this._ldap;
    }

    public void setLdap(LdapConfig ldap) {
        this._ldap = ldap;
    }

    @Nonnull
    public String getExternalId() {
        return this._externalId;
    }

    public void setExternalId(String externalId) {
        this._externalId = externalId;
    }

    public String getMembershipAttribute() {
        return this.getLdap().getMembershipAttribute();
    }

    public String getMemberAttribute() {
        return this.getLdap().getMemberAttribute();
    }

    public Name getUserGroupSearchBaseDn() {
        return LdapUtils.newLdapName((String)this.getLdap().getSearchBaseDn());
    }

    public boolean useDirectGroupMembers() {
        return this.getLdap().isUseDirectGroupMembers();
    }

    public String getFilter() {
        return this.getLdap().getFilter();
    }

    public String getExternalIdAttribute() {
        return this.getExternalId();
    }

    public int getLdapPageSize() {
        return this.getLdap().getPageSize();
    }

    public boolean getUsePagination() {
        return this.getLdap().getUsePagination();
    }

    public boolean getProfileCacheEnabled() {
        return this.getLdap().getProfileCacheEnabled();
    }

    @CheckForNull
    public String getUserGroupNameAttribute() {
        return this.getLdap().getUserGroupNameAttribute();
    }
}

