/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.Manager;
import com.unboundid.scim2.common.types.UserResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class PatchRequestUtils {
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(PatchRequestUtils.class);

    @Nonnull
    public static UserResource patchUser(UserResource user, PatchRequest patch) throws ScimException, JsonProcessingException {
        PatchRequest fixedPatch = PatchRequestUtils.fixPatchRequest((UserResource)user, (PatchRequest)patch);
        GenericScimResource genericResource = user.asGenericScimResource();
        fixedPatch.apply(genericResource);
        return (UserResource)MAPPER.readValue(genericResource.getObjectNode().toString(), UserResource.class);
    }

    @Nonnull
    private static PatchRequest fixPatchRequest(UserResource user, PatchRequest request) {
        List fixedOperations = PatchRequestUtils.fixOperations((UserResource)user, (PatchRequest)request);
        return new PatchRequest(PatchRequestUtils.filterInvalidValues((List)fixedOperations));
    }

    @Nonnull
    private static List<PatchOperation> fixOperations(UserResource user, PatchRequest request) {
        return PatchRequestUtils.fixMissingPath((PatchRequest)request).stream().map(operation -> PatchRequestUtils.fixOperationType((UserResource)user, (PatchOperation)operation)).toList();
    }

    @Nonnull
    private static PatchOperation fixOperationType(UserResource user, PatchOperation operation) {
        if (PatchOpType.REPLACE.equals((Object)operation.getOpType()) && !PatchRequestUtils.hasAttributeValue((UserResource)user, (Path)operation.getPath())) {
            return PatchOperation.add((Path)operation.getPath(), (JsonNode)operation.getJsonNode());
        }
        return operation;
    }

    private static boolean hasAttributeValue(UserResource user, @Nullable Path path) {
        try {
            return path != null && !user.asGenericScimResource().getValue(path).isEmpty();
        }
        catch (ScimException e) {
            LOG.error("Error parsing user resource: ${}", (Object)user);
            return false;
        }
    }

    @Nonnull
    private static List<PatchOperation> fixMissingPath(PatchRequest request) {
        ArrayList<PatchOperation> fixedOperations = new ArrayList<PatchOperation>();
        List originalOperations = request.getOperations();
        originalOperations.forEach(operation -> {
            if (operation.getPath() != null) {
                fixedOperations.add((PatchOperation)operation);
                return;
            }
            try {
                HashMap values = (HashMap)operation.getValue(HashMap.class);
                values.forEach((key, value) -> {
                    PatchOperation fixedOp = PatchRequestUtils.fixOperation((PatchOpType)operation.getOpType(), (String)key, (Object)value);
                    if (fixedOp != null) {
                        fixedOperations.add(fixedOp);
                    }
                });
            }
            catch (JsonProcessingException | ScimException e) {
                throw new IllegalStateException(String.format("Received incompatible PatchOperation: %s", operation));
            }
        });
        return fixedOperations;
    }

    @Nonnull
    private static List<PatchOperation> filterInvalidValues(List<PatchOperation> operations) {
        return operations.stream().filter(operation -> !PatchRequestUtils.hasInvalidManagerAttribute((PatchOperation)operation)).toList();
    }

    private static boolean hasInvalidManagerAttribute(PatchOperation operation) {
        if (operation.getPath().toString().equals("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager")) {
            try {
                operation.getValue(Manager.class);
                return false;
            }
            catch (JsonProcessingException | ScimException e) {
                LOG.info("Found invalid manager attribute. Ignoring. Operation: {}", (Object)operation);
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    private static PatchOperation fixOperation(PatchOpType opType, String key, Object value) {
        try {
            HashMap<String, Object> patchOperation = new HashMap<String, Object>();
            patchOperation.put("op", opType);
            patchOperation.put("path", Path.fromString((String)key));
            patchOperation.put("value", value);
            JsonNode jsonNode = MAPPER.valueToTree(patchOperation);
            return (PatchOperation)MAPPER.treeToValue((TreeNode)jsonNode, PatchOperation.class);
        }
        catch (JsonProcessingException | BadRequestException e) {
            LOG.error("Could not fix operation", e);
            return null;
        }
    }
}

