/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justimport.business.model.ScimImportedAttributes;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ScimImportedAttributesProducer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String TOPIC = "just.import.user.attributes";
    private static final Logger LOG = LoggerFactory.getLogger(ScimImportedAttributesProducer.class);
    private final KafkaCleaningProducer<String, String> _kafkaProducer;

    public ScimImportedAttributesProducer(KafkaCleaningProducer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish attribute data to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public void publishImportedAttributes(UUID profileUid, ScimImportedAttributes attributes) {
        try {
            this._kafkaProducer.send(new ProducerRecord(TOPIC, (Object)profileUid.toString(), (Object)OBJECT_MAPPER.writeValueAsString((Object)attributes)), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to create record for imported attributes.", (Throwable)e);
        }
    }
}

