/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.externalid;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.persistence.model.DbExternalIdMapping;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ExternalIdMapping {
    private final TenantId _tenantId;
    private final ExternalSystemId _systemId;
    private final InternalId _internalId;
    private final ExternalId _externalId;

    public ExternalIdMapping(TenantId tenantId, ExternalSystemId externalSystemId, InternalId internalId, ExternalId externalId) {
        this._tenantId = tenantId;
        this._systemId = externalSystemId;
        this._internalId = internalId;
        this._externalId = externalId;
    }

    @Nonnull
    public DbExternalIdMapping toDbObject() {
        return DbExternalIdMapping.fromDto((ExternalIdMapping)this);
    }

    @Nonnull
    public ExternalSystemId getSystemId() {
        return this._systemId;
    }

    @Nonnull
    public InternalId getInternalId() {
        return this._internalId;
    }

    @Nonnull
    public ExternalId getExternalId() {
        return this._externalId;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIdMapping that = (ExternalIdMapping)o;
        return Objects.equals(this._tenantId, that._tenantId) && Objects.equals(this._systemId, that._systemId) && Objects.equals(this._internalId, that._internalId) && Objects.equals(this._externalId, that._externalId);
    }

    public int hashCode() {
        return Objects.hash(this._tenantId, this._systemId, this._internalId, this._externalId);
    }
}

