/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.externalid;

import com.google.common.base.Joiner;
import de.justsoftware.justimport.domain.model.common.ItemType;
import de.justsoftware.justimport.domain.model.common.StringId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ExternalId
extends StringId {
    private static final Joiner EXTERNAL_ID_JOINER = Joiner.on((String)"@").skipNulls();

    public ExternalId(String id, ItemType type) {
        super(id, type);
    }

    public ExternalId(String externalId, @Nullable String domain, ItemType type) {
        this(EXTERNAL_ID_JOINER.join((Object)externalId, (Object)domain, new Object[0]), type);
    }

    @Nonnull
    public static ExternalId parse(@Nullable String idStr) {
        String[] parts;
        if (idStr != null && (parts = idStr.split(",")).length == 2) {
            ItemType itemType = ItemType.valueOf((String)parts[0]);
            return new ExternalId(parts[1], itemType);
        }
        throw new IllegalArgumentException("Could not parse '" + idStr + "'");
    }
}

