/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.resolver;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.Name;
import org.springframework.ldap.support.LdapUtils;

@ParametersAreNonnullByDefault
public class MembersLookupResult {
    private final Name _dn;
    private final Set<Name> _members;

    public MembersLookupResult(Name dn, @Nullable String[] members) {
        this._dn = dn;
        this._members = members == null ? null : Arrays.stream(members).map(LdapUtils::newLdapName).collect(Collectors.toSet());
    }

    @Nonnull
    public Name getDn() {
        return this._dn;
    }

    @Nonnull
    public Set<Name> getMembers() {
        return this._members == null ? Set.of() : this._members;
    }

    public boolean isGroup() {
        return this._members != null;
    }

    public boolean isPerson() {
        return this._members == null;
    }
}

